#include "Behavioural/include/Usage.h"
#include "Common/include/Debug.h"
#include "Common/include/ErrorMorpheo.h"

namespace morpheo {
namespace behavioural {

  Tusage_t usage_set         (Tusage_t usage, Tusage_t flag)
  {
    return  ( usage | flag);
  }

  Tusage_t usage_unset       (Tusage_t usage, Tusage_t flag)
  {
    return ~(~usage | flag);
  }  

  bool     usage_is_set      (Tusage_t usage, Tusage_t flag)
  {
    return ((usage & flag) != 0);
  }

  void     usage_environment (Tusage_t usage)
  {
#ifndef SYSTEMC
    if (usage_is_set(usage,USE_SYSTEMC))
      throw ErrorMorpheo(_("Component use the flag \"USE_SYSTEMC\", but the macro's compiler \"SYSTEMC\" is unset."));
#endif
#ifndef VHDL
    if (usage_is_set(usage,USE_VHDL))
      throw ErrorMorpheo(_("Component use the flag \"USE_VHDL\", but the macro's compiler \"VHDL\" is unset."));
#endif
#ifndef VHDL_TESTBENCH
    if (usage_is_set(usage,USE_VHDL_TESTBENCH))
      throw ErrorMorpheo(_("Component use the flag \"USE_VHDL_TESTBENCH\", but the macro's compiler \"VHDL_TESTBENCH\" is unset."));
#endif
#ifndef VHDL_TESTBENCH_ASSERT
    if (usage_is_set(usage,USE_VHDL_TESTBENCH_ASSERT))
      throw ErrorMorpheo(_("Component use the flag \"USE_VHDL_TESTBENCH_ASSERT\", but the macro's compiler \"VHDL_TESTBENCH_ASSERT\" is unset."));
#endif
#ifndef POSITION
    if (usage_is_set(usage,USE_POSITION))
      throw ErrorMorpheo(_("Component use the flag \"USE_POSITION\", but the macro's compiler \"POSITION\" is unset."));
#endif
#ifndef STATISTICS
    if (usage_is_set(usage,USE_STATISTICS))
      throw ErrorMorpheo(_("Component use the flag \"USE_STATISTICS\", but the macro's compiler \"STATISTICS\" is unset."));
#endif
#ifndef INFORMATION
    if (usage_is_set(usage,USE_INFORMATION))
      throw ErrorMorpheo(_("Component use the flag \"USE_INFORMATION\", but the macro's compiler \"INFORMATION\" is unset."));
#endif

#ifndef DEBUG
#endif

    if (usage_is_set(usage,USE_STATISTICS) and not usage_is_set(usage,USE_SYSTEMC))
      throw ErrorMorpheo(_("Usage flags conflit : to use the statistics, you must set flag USE_SYSTEMC"));
    
    if (usage_is_set(usage,USE_INFORMATION) and not usage_is_set(usage,USE_STATISTICS))
      throw ErrorMorpheo(_("Usage flags conflit : to use the information, you must set flag USE_STATISTICS"));
    
    if (usage_is_set(usage,USE_VHDL_TESTBENCH) and not usage_is_set(usage,USE_SYSTEMC))
      throw ErrorMorpheo(_("Usage flags conflit : to use the vhdl's test bench, you must set flag USE_SYSTEMC"));
    
    if (usage_is_set(usage,USE_VHDL_TESTBENCH) and not usage_is_set(usage,USE_VHDL))
      throw ErrorMorpheo(_("Usage flags conflit : to use the vhdl's test bench, you must set flag USE_VHDL"));
    
    if (usage_is_set(usage,USE_VHDL_TESTBENCH_ASSERT) and not usage_is_set(usage,USE_VHDL_TESTBENCH))
      throw ErrorMorpheo(_("Usage flags conflit : to use an assert in vhdl's test bench, you must set flag USE_VHDL_TESTBENCH"));
  }

  Tusage_t usage_all (void)
  {
    Tusage_t usage = USE_NONE;

#ifdef SYSTEMC
    usage = usage_set(usage,USE_SYSTEMC);
#endif
#ifdef VHDL
    usage = usage_set(usage,USE_VHDL);
#endif
#ifdef VHDL_TESTBENCH
    usage = usage_set(usage,USE_VHDL_TESTBENCH);
#endif
#ifdef VHDL_TESTBENCH_ASSERT
    usage = usage_set(usage,USE_VHDL_TESTBENCH_ASSERT);
#endif
#ifdef POSITION
    usage = usage_set(usage,USE_POSITION);
#endif
#ifdef STATISTICS
    usage = usage_set(usage,USE_STATISTICS);
#endif
#ifdef INFORMATION
    usage = usage_set(usage,USE_INFORMATION);
#endif

#ifdef DEBUG
#endif
    
    return usage;
  }


}; // end namespace behavioural
}; // end namespace morpheo              
