#include "../include/Cache_MultiLevel.h"
#include <sstream>

namespace environment {
namespace cache {
namespace cache_multilevel {

  Access Cache_MultiLevel::access (uint32_t num_port, uint32_t address, uint32_t trdid, type_req_cache_t type, direction_req_cache_t dir)
  {
    uint32_t         time          = 0;
    uint32_t         last_nb_level = (param->nb_level==0)?0:(param->nb_level-1);
    type_rsp_cache_t hit           = MISS;
    
    // Scan all cache level
    for (uint32_t i = 0; i < param->nb_level; i ++)
      {
	hit   = hierarchy_cache[i]->access (num_port,address,trdid,type,dir);
	uint32_t latence = hierarchy_cache[i]->latence(num_port);
	time += latence;

	_cout(CACHE,"    * Level [%d] - type_hit %d, latence %d, Sum latence %d\n",i,hit,latence,time);

	if ( (hit == HIT_CACHE)        or
	     (hit == HIT_WRITE_BUFFER) or
	     (hit == HIT_BYPASS)       )
	  {
	    last_nb_level = i;
	    break;
	  }
      }
    
    return Access (num_port,hit,time,last_nb_level);
  }

};
};
};
