#ifndef ENVIRONMENT_ENDIANNESS_H
#define ENVIRONMENT_ENDIANNESS_H

#include <stdint.h>

namespace environment {
namespace endianness {

#define LittleEndian false
#define BigEndian    true
  
  typedef union 
  {
    uint32_t word;
    
    struct 
    {
      uint8_t byte1;
      uint8_t byte2;
      uint8_t byte3;
      uint8_t byte4;
    } bytes;
  } TestEndian ;
  
  bool   hostEndianness   ();
  bool   cpuEndianness    (uint32_t cpu_id);
  bool   isSameEndianness (uint32_t cpu_id);
  char * swapBytes        (char *   string_src , 
			   uint32_t size_string, 
			   uint32_t size_access);
  
};
};
#endif
