#include "../include/Sim2OS.h"

namespace environment {
namespace sim2os {

  /*
   * convert a address in the simulator on a address in OS
   */
  void * Sim2OS::convert_address (void * address)
  {
    void * result = param->segment_table->getAddrAlloc((uint32_t)address);
    
    if (result == NULL)
      {
	std::cerr << "<" << name << "> address don't match : " << std::hex << (uint32_t)(address) << std::dec << std::endl;
	exit(0);
      }
    
    return result;
  }

};
};
