#ifndef SERVICE_READ_H
#define SERVICE_READ_H

#include "../sim2os.h"

namespace hierarchy_memory {
  namespace sim2os {

    //~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~[service_read ]~~~~~
    void *
    Sim2os ::
    service_read ()
    {
      if (have_all_arguments(3) == false)
	{
	  cerr << "<" << NAME << "> Usage : ssize_t read(int fd, void *buf, size_t count);" << endl;
	  return NULL;
	}
  
      int         fd       = (int)          arguments[1];
      void *      buf      = (void *)       convert_address(arguments[2]);
      ssize_t     count    = (ssize_t)      arguments[3];
      void *      result   = (void *)       read(fd,buf,count);

      cout << "\n\t***** service : read          *****"        << endl;
      cout << "\tfd        : " <<        (unsigned int) fd     << endl;
      cout << "\tbuf       : " << hex << (unsigned int) buf    << endl;
      //cout << "\tbuf       : " << dec << (char *)       buf    << endl;
      cout << "\tcount     : " << dec << (unsigned int) count  << endl;
      cout << "\tresult    : " <<        (unsigned int) result << endl;
      cout << "\terrno     : " <<        (unsigned int) error  << endl;

      error                = errno;
      return      result;
    }

  };};
#endif //SERVICE_READ_H
