/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/SelfTest/include/test.h"

#define number_of_test 2

#define NB_PARAMS 14

void usage (int argc, char * argv[])
{
  cerr << "<Usage> " << argv[0] << " name_instance list_params" << endl
       << "list_params is :" << endl
       << " - size_store_queue        (uint32_t)" << endl
       << " - size_load_queue         (uint32_t)" << endl
       << " - size_speculative_access_queue (uint32_t)" << endl
       << " - nb_port_check           (uint32_t)" << endl
       << " - speculative_load        (uint32_t)" << endl
       << " - nb_bypass_memory        (uint32_t)" << endl
       << " - nb_context              (uint32_t)" << endl
       << " - nb_front_end            (uint32_t)" << endl
       << " - nb_ooo_engine           (uint32_t)" << endl
       << " - nb_packet               (uint32_t)" << endl
       << " - size_general_data       (uint32_t)" << endl
       << " - size_special_data       (uint32_t)" << endl
       << " - nb_general_register     (uint32_t)" << endl
       << " - nb_special_register     (uint32_t)" << endl
       << "" << endl;

  for (int i=0; i<argc; i++)
    cerr << argv[i] << " ";
  cerr << endl;

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  switch (number_of_test)
    {
    case 1 :
      {
	
	if (argc != 2+NB_PARAMS)
	  usage (argc, argv);
	
	uint32_t x=1;
	
	const string              name                     = argv[x++];
	const uint32_t            _size_store_queue        = atoi(argv[x++]);
	const uint32_t            _size_load_queue         = atoi(argv[x++]);
	const uint32_t            _size_speculative_access_queue = atoi(argv[x++]);
	const uint32_t            _nb_port_check           = atoi(argv[x++]);
	const Tspeculative_load_t _speculative_load        = fromString<Tspeculative_load_t>(argv[x++]);
	const uint32_t            _nb_bypass_memory        = atoi(argv[x++]);
	const uint32_t            _nb_context              = atoi(argv[x++]);
	const uint32_t            _nb_front_end            = atoi(argv[x++]);
	const uint32_t            _nb_ooo_engine           = atoi(argv[x++]);
	const uint32_t            _nb_packet               = atoi(argv[x++]);
	const uint32_t            _size_general_data       = atoi(argv[x++]);
	const uint32_t            _size_special_data       = atoi(argv[x++]);
	const uint32_t            _nb_general_register     = atoi(argv[x++]);
	const uint32_t            _nb_special_register     = atoi(argv[x++]);
	
	try 
	  {
	    morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters * param = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_execute_unit::execute_unit::load_store_unit::Parameters
	      (
	       _size_store_queue       ,
	       _size_load_queue        ,
	       _size_speculative_access_queue,
	       _nb_port_check          ,
	       _speculative_load       ,
	       _nb_bypass_memory       ,
	       _nb_context             ,
	       _nb_front_end           ,
	       _nb_ooo_engine          ,
	       _nb_packet              ,
	       _size_general_data      ,
	       _size_special_data      ,
	       _nb_general_register    ,
	       _nb_special_register    );
	    
	    cout << param->print(1);
	    
	    test1 (name,param);
	    
	  }
	catch (morpheo::ErrorMorpheo & error)
	  {
	    cout << "<" << name << "> : " <<  error.what ();
	    exit (EXIT_FAILURE);
	  }
	catch (...)
	  {
	    cerr << "<" << name << "> : This test must generate a error" << endl;
	    exit (EXIT_FAILURE);
	  }
	
	break;
      }
    case 2 :
      {
	try 
	  {
	    test2 ();
	  }
	catch (morpheo::ErrorMorpheo & error)
	  {
	    cout << error.what ();
	    exit (EXIT_FAILURE);
	  }
	catch (...)
	  {
	    cerr << "This test must generate a error" << endl;
	    exit (EXIT_FAILURE);
	  }
	
	break;
      }
    default :
      {
	std::cerr << "Invalid number of test" << std::endl;
	exit (EXIT_FAILURE);

	break;
      }
    }
  
  return (EXIT_SUCCESS);
}

