#ifdef SYSTEMC
/*
 * $Id: Execute_queue_transition.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Execute_queue/include/Execute_queue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace execute_queue {


#undef  FUNCTION
#define FUNCTION "Execute_queue::transition"
  void Execute_queue::transition (void)
  {
    log_printf(FUNC,Execute_queue,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	// Flush queue
	// FIXME "queue reset"
	// > 1) flush one slot by cycle
	// > 2) flush all slot in one cycle

	while (_queue->empty() == false)
	  _queue->pop();
      }
    else
      {
	// Test if push
	if (PORT_READ(in_EXECUTE_QUEUE_IN_VAL) and internal_EXECUTE_QUEUE_IN_ACK)
	  {
	    execute_queue_entry_t * entry = new execute_queue_entry_t
	      ((_param->_have_port_context_id   )?PORT_READ(in_EXECUTE_QUEUE_IN_CONTEXT_ID   ):0,
	       (_param->_have_port_front_end_id )?PORT_READ(in_EXECUTE_QUEUE_IN_FRONT_END_ID ):0,
	       (_param->_have_port_ooo_engine_id)?PORT_READ(in_EXECUTE_QUEUE_IN_OOO_ENGINE_ID):0,
	       (_param->_have_port_packet_id    )?PORT_READ(in_EXECUTE_QUEUE_IN_PACKET_ID    ):0,
	     //PORT_READ(in_EXECUTE_QUEUE_IN_OPERATION    ),
	     //PORT_READ(in_EXECUTE_QUEUE_IN_TYPE         ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_FLAGS        ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_EXCEPTION    ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_NO_SEQUENCE  ),
	       PORT_READ(in_EXECUTE_QUEUE_IN_ADDRESS      ));
	    
	    _queue->push(entry);
	  }

	// Test if pop
	if (internal_EXECUTE_QUEUE_OUT_VAL and PORT_READ(in_EXECUTE_QUEUE_OUT_ACK))
	  {
	    delete _queue->front();
	    _queue->pop();
	  }
      }

#ifdef STATISTICS
    *(_stat_use_queue) += _queue->size();
#endif
    

#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Execute_queue,FUNCTION,"End");
  };

}; // end namespace execute_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
