#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_write_queue_Write_queue_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_multi_write_unit_write_unit_write_queue_Write_queue_h

/*
 * $Id: Write_queue.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Write_unit/Write_unit/Write_queue/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_write_unit {
namespace write_unit {
namespace write_queue {

  class write_queue_entry_t
  {
  public  : Tcontext_t         _context_id   ;
  public  : Tcontext_t         _front_end_id ;
  public  : Tcontext_t         _ooo_engine_id;
  public  : Tpacket_t          _packet_id    ;
//public  : Toperation_t       _operation    ;
  public  : Ttype_t            _type         ;
  public  : Tcontrol_t         _write_rd     ;
  public  : Tgeneral_address_t _num_reg_rd   ;
  public  : Tgeneral_data_t    _data_rd      ;
  public  : Tcontrol_t         _write_re     ;
  public  : Tspecial_address_t _num_reg_re   ;
  public  : Tspecial_data_t    _data_re      ;
  public  : Texception_t       _exception    ;
  public  : Tcontrol_t         _no_sequence  ;
  public  : Tgeneral_data_t    _address      ;
    
  public  : write_queue_entry_t (Tcontext_t         context_id   ,
				 Tcontext_t         front_end_id ,
				 Tcontext_t         ooo_engine_id,
				 Tpacket_t          packet_id    ,
			       //Toperation_t       operation    ,
				 Ttype_t            type         ,
				 Tcontrol_t         write_rd     ,
				 Tgeneral_address_t num_reg_rd   ,
				 Tgeneral_data_t    data_rd      ,
				 Tcontrol_t         write_re     ,
				 Tspecial_address_t num_reg_re   ,
				 Tspecial_data_t    data_re      ,
				 Texception_t       exception    ,
				 Tcontrol_t         no_sequence  ,
				 Tgeneral_data_t    address      )
    {
      _context_id    = context_id   ;
      _front_end_id  = front_end_id ;
      _ooo_engine_id = ooo_engine_id;
      _packet_id     = packet_id    ;
    //_operation     = operation    ;
      _type          = type         ;
      _write_rd      = write_rd     ;
      _num_reg_rd    = num_reg_rd   ;
      _data_rd       = data_rd      ;
      _write_re      = write_re     ;
      _num_reg_re    = num_reg_re   ;
      _data_re       = data_re      ;
      _exception     = exception    ;
      _no_sequence   = no_sequence  ;
      _address       = address      ;
    };
  };


  class Write_queue 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;

  private   : counter_t                      * _stat_use_queue;
  private   : counter_t                      * _stat_average_use_queue;
  private   : counter_t                      * _stat_percent_use_queue;

#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // -----[ Interface "Write_queue_in" ]--------------------------------    
  public    : SC_IN (Tcontrol_t        )    *  in_WRITE_QUEUE_IN_VAL          ;
  public    : SC_OUT(Tcontrol_t        )    * out_WRITE_QUEUE_IN_ACK          ;
  public    : SC_IN (Tcontext_t        )    *  in_WRITE_QUEUE_IN_CONTEXT_ID   ;
  public    : SC_IN (Tcontext_t        )    *  in_WRITE_QUEUE_IN_FRONT_END_ID ;
  public    : SC_IN (Tcontext_t        )    *  in_WRITE_QUEUE_IN_OOO_ENGINE_ID;
  public    : SC_IN (Tpacket_t         )    *  in_WRITE_QUEUE_IN_PACKET_ID    ;
//public    : SC_IN (Toperation_t      )    *  in_WRITE_QUEUE_IN_OPERATION    ;
  public    : SC_IN (Ttype_t           )    *  in_WRITE_QUEUE_IN_TYPE         ;
  public    : SC_IN (Tcontrol_t        )    *  in_WRITE_QUEUE_IN_WRITE_RD     ;
  public    : SC_IN (Tgeneral_address_t)    *  in_WRITE_QUEUE_IN_NUM_REG_RD   ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_WRITE_QUEUE_IN_DATA_RD      ;
  public    : SC_IN (Tcontrol_t        )    *  in_WRITE_QUEUE_IN_WRITE_RE     ;
  public    : SC_IN (Tspecial_address_t)    *  in_WRITE_QUEUE_IN_NUM_REG_RE   ;
  public    : SC_IN (Tspecial_data_t   )    *  in_WRITE_QUEUE_IN_DATA_RE      ;
  public    : SC_IN (Texception_t      )    *  in_WRITE_QUEUE_IN_EXCEPTION    ;
  public    : SC_IN (Tcontrol_t        )    *  in_WRITE_QUEUE_IN_NO_SEQUENCE  ;
  public    : SC_IN (Tgeneral_data_t   )    *  in_WRITE_QUEUE_IN_ADDRESS      ;

    // -----[ Interface "Write_queue_out" ]-------------------------------    
  public    : SC_OUT(Tcontrol_t        )    * out_WRITE_QUEUE_OUT_VAL          ;
  public    : SC_IN (Tcontrol_t        )    *  in_WRITE_QUEUE_OUT_ACK          ;
  public    : SC_OUT(Tcontext_t        )    * out_WRITE_QUEUE_OUT_CONTEXT_ID   ;
  public    : SC_OUT(Tcontext_t        )    * out_WRITE_QUEUE_OUT_FRONT_END_ID ;
  public    : SC_OUT(Tcontext_t        )    * out_WRITE_QUEUE_OUT_OOO_ENGINE_ID;
  public    : SC_OUT(Tpacket_t         )    * out_WRITE_QUEUE_OUT_PACKET_ID    ;
//public    : SC_OUT(Toperation_t      )    * out_WRITE_QUEUE_OUT_OPERATION    ;
//public    : SC_OUT(Ttype_t           )    * out_WRITE_QUEUE_OUT_TYPE         ;
  public    : SC_OUT(Tspecial_data_t   )    * out_WRITE_QUEUE_OUT_FLAGS        ;
  public    : SC_OUT(Texception_t      )    * out_WRITE_QUEUE_OUT_EXCEPTION    ;
  public    : SC_OUT(Tcontrol_t        )    * out_WRITE_QUEUE_OUT_NO_SEQUENCE  ;
  public    : SC_OUT(Tgeneral_data_t   )    * out_WRITE_QUEUE_OUT_ADDRESS      ;

    // -----[ Interface "gpr_write" ]-------------------------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_GPR_WRITE_VAL               ;
  public    : SC_IN (Tcontrol_t        )   **  in_GPR_WRITE_ACK               ;
  public    : SC_OUT(Tcontext_t        )   ** out_GPR_WRITE_OOO_ENGINE_ID     ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_GPR_WRITE_NUM_REG           ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_GPR_WRITE_DATA              ;
    
    // -----[ Interface "spr_write" ]-------------------------------------
  public    : SC_OUT(Tcontrol_t        )   ** out_SPR_WRITE_VAL               ;
  public    : SC_IN (Tcontrol_t        )   **  in_SPR_WRITE_ACK               ;
  public    : SC_OUT(Tcontext_t        )   ** out_SPR_WRITE_OOO_ENGINE_ID     ;
  public    : SC_OUT(Tspecial_address_t)   ** out_SPR_WRITE_NUM_REG           ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_SPR_WRITE_DATA              ;

    // -----[ Interface "bypass_write" ]----------------------------------
  public    : SC_OUT(Tcontext_t        )   ** out_BYPASS_WRITE_OOO_ENGINE_ID ;
  public    : SC_OUT(Tcontrol_t        )   ** out_BYPASS_WRITE_GPR_VAL       ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_BYPASS_WRITE_GPR_NUM_REG   ; // RD
  public    : SC_OUT(Tgeneral_data_t   )   ** out_BYPASS_WRITE_GPR_DATA      ;
  public    : SC_OUT(Tcontrol_t        )   ** out_BYPASS_WRITE_SPR_VAL       ;
  public    : SC_OUT(Tspecial_address_t)   ** out_BYPASS_WRITE_SPR_NUM_REG   ; // RE
  public    : SC_OUT(Tspecial_data_t   )   ** out_BYPASS_WRITE_SPR_DATA      ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  protected : std::list<write_queue_entry_t *> * _queue;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Tcontrol_t     internal_WRITE_QUEUE_IN_ACK;
    Tcontrol_t     internal_WRITE_QUEUE_OUT_VAL;
    Tcontrol_t     internal_GPR_WRITE_VAL;
    Tcontrol_t     internal_SPR_WRITE_VAL;
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Write_queue);
#endif
  public  :          Write_queue              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Write_queue             (void);
					       
  private : void     allocation                (void);
  private : void     deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void     transition                (void);
  public  : void     genMoore                  (void);
#endif					       
#ifdef STATISTICS
  public  : void     statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
					       
#if VHDL				       
  public  : void     vhdl                      (void);
  private : void     vhdl_declaration          (Vhdl * & vhdl);
  private : void     vhdl_body                 (Vhdl * & vhdl);
#endif					       
					       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void     end_cycle                 (void);
#endif
  };

}; // end namespace write_queue
}; // end namespace write_unit
}; // end namespace multi_write_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
