#ifdef SYSTEMC
/*
 * $Id: Ifetch_unit_Glue_genMealy_icache_req.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Ifetch_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace ifetch_unit_glue {


#undef  FUNCTION
#define FUNCTION "Ifetch_unit_Glue::genMealy_icache_req"
  void Ifetch_unit_Glue::genMealy_icache_req (void)
  {
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"Begin");

    Tcontrol_t address_val = PORT_READ(in_ICACHE_REQ_ADDRESS_VAL);
    Tcontrol_t queue_ack   = PORT_READ(in_ICACHE_REQ_QUEUE_ACK  );
    Tcontrol_t ack         = PORT_READ(in_ICACHE_REQ_ACK        );

    PORT_WRITE(out_ICACHE_REQ_VAL        , address_val and queue_ack); // have a address valid and queue have a slot empty
    PORT_WRITE(out_ICACHE_REQ_ADDRESS_ACK, ack         and queue_ack); // cache can accept a new transaction and queue have a slot empty
    PORT_WRITE(out_ICACHE_REQ_QUEUE_VAL  , address_val and ack); // cache can accept a new transaction and the address is valid
    
    log_printf(FUNC,Ifetch_unit_Glue,FUNCTION,"End");
  };

}; // end namespace ifetch_unit_glue
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
