/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/SelfTest/include/test.h"

#define NB_PARAMS 4

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * size_queue                    (uint32_t)\n"));
  err (_(" * nb_instruction                (uint32_t)\n"));
  err (_(" * size_branch_update_prediction (uint32_t)\n"));
  err (_(" * size_general_data             (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc != static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t _size_queue                    = fromString<uint32_t>(argv[x++]);
  uint32_t _nb_instruction                = fromString<uint32_t>(argv[x++]);
  uint32_t _size_branch_update_prediction = fromString<uint32_t>(argv[x++]);
  uint32_t _size_general_data             = fromString<uint32_t>(argv[x++]);
  
  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::Parameters
	(_size_queue                    ,
	 _nb_instruction                ,
	 _size_branch_update_prediction ,
	 _size_general_data             );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }

  return (_return);
}
