#ifndef morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_Ifetch_unit_h
#define morpheo_behavioural_core_multi_front_end_front_end_ifetch_unit_Ifetch_unit_h

/*
 * $Id: Ifetch_unit.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_queue/include/Ifetch_queue.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Ifetch_unit_Glue/include/Ifetch_unit_Glue.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {


  class Ifetch_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "icache_req" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t           ) * out_ICACHE_REQ_VAL                      ;
  public    : SC_IN (Tcontrol_t           ) *  in_ICACHE_REQ_ACK                      ;
//public    : SC_OUT(Tcontext_t           ) * out_ICACHE_REQ_THREAD_ID                ;
  public    : SC_OUT(Tpacket_t            ) * out_ICACHE_REQ_PACKET_ID                ;
  public    : SC_OUT(Ticache_instruction_t) * out_ICACHE_REQ_ADDRESS                  ;
  public    : SC_OUT(Ticache_type_t       ) * out_ICACHE_REQ_TYPE                     ;

    // ~~~~~[ Interface "icache_rsp" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t           ) *  in_ICACHE_RSP_VAL                      ;
  public    : SC_OUT(Tcontrol_t           ) * out_ICACHE_RSP_ACK                      ;
//public    : SC_IN (Tcontext_t           ) *  in_ICACHE_RSP_THREAD_ID                ;
  public    : SC_IN (Tpacket_t            ) *  in_ICACHE_RSP_PACKET_ID                ;
  public    : SC_IN (Ticache_instruction_t)**  in_ICACHE_RSP_INSTRUCTION              ;//[nb_instruction]
  public    : SC_IN (Ticache_error_t      ) *  in_ICACHE_RSP_ERROR                    ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )   * out_PREDICT_VAL                         ;
  public    : SC_IN (Tcontrol_t         )   *  in_PREDICT_ACK                         ;
  public    : SC_OUT(Tgeneral_address_t )   * out_PREDICT_PC_PREVIOUS                 ;
  public    : SC_OUT(Tgeneral_address_t )   * out_PREDICT_PC_CURRENT                  ;
  public    : SC_OUT(Tcontrol_t         )   * out_PREDICT_PC_CURRENT_IS_DS_TAKE       ;
  public    : SC_IN (Tgeneral_address_t )   *  in_PREDICT_PC_NEXT                     ;
  public    : SC_IN (Tcontrol_t         )   *  in_PREDICT_PC_NEXT_IS_DS_TAKE          ;
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_INSTRUCTION_ENABLE          ; //[nb_instruction]
  public    : SC_IN (Tinst_ifetch_ptr_t )   *  in_PREDICT_INST_IFETCH_PTR             ;
  public    : SC_IN (Tbranch_state_t    )   *  in_PREDICT_BRANCH_STATE                ;
  public    : SC_IN (Tprediction_ptr_t  )   *  in_PREDICT_BRANCH_UPDATE_PREDICTION_ID ;

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_VAL                           ;//[nb_instruction]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_ACK                           ;//[nb_instruction]
  public    : SC_OUT(Tinstruction_t     )  ** out_DECOD_INSTRUCTION                   ;//[nb_instruction]
//public    : SC_OUT(Tcontext_t         )   * out_DECOD_CONTEXT_ID                    ;
  public    : SC_OUT(Tgeneral_address_t )   * out_DECOD_ADDRESS                       ;
  public    : SC_OUT(Tinst_ifetch_ptr_t )   * out_DECOD_INST_IFETCH_PTR               ;
  public    : SC_OUT(Tbranch_state_t    )   * out_DECOD_BRANCH_STATE                  ;
  public    : SC_OUT(Tprediction_ptr_t  )   * out_DECOD_BRANCH_UPDATE_PREDICTION_ID   ;
  public    : SC_OUT(Texception_t       )   * out_DECOD_EXCEPTION                     ;

    // ~~~~~[ Interface "event" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )    *  in_EVENT_VAL                           ;
  public    : SC_OUT(Tcontrol_t        )    * out_EVENT_ACK                           ;
  public    : SC_IN (Tgeneral_address_t)    *  in_EVENT_ADDRESS                       ;
    
    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::address_management::Address_management * _component_address_management;
  private   : morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_queue::      Ifetch_queue       * _component_ifetch_queue;
  private   : morpheo::behavioural::core::multi_front_end::front_end::ifetch_unit::ifetch_unit_glue::  Ifetch_unit_Glue   * _component_ifetch_unit_glue;

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Ifetch_unit);
#endif
  public  :          Ifetch_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Ifetch_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
# if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
# endif					       
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
