/*
 * $Id: Parameters_msg_error.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Parameters.h"
#include <sstream>

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_register {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Register::msg_error"
  Parameters_test Parameters::msg_error(void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"Begin");

    Parameters_test test ("Branch_Target_Buffer_Register");

    if (_size_counter < 2 )
      test.error("size_counter must be >= 2.");

    if ((_associativity == 0) or
	(_associativity > _size_buffer))
      test.error("associativity must be > 0 and <= size_buffer.");

    if (_associativity == 1) // special case : full assoc and direct map ... also we print direct map
      test.information("Branch Target Buffer is Direct Map");
    else
      if (_associativity == _size_buffer)
	test.information("Branch Target Buffer is Full associative");
      else
	test.information("Branch Target Buffer is Semi associative");

    for (uint32_t i=0; i<_nb_context; i++)
      if (_associativity < (_nb_instruction[i]/2))
	test.error("associativity must be >= nb_instruction["+toString(i)+"]/2.");

    log_printf(FUNC,Branch_Target_Buffer_Register,FUNCTION,"End");

    return test;
  };

}; // end namespace branch_target_buffer_register
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
