/*
 * $Id: test.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

#define NB_ITERATION  1024
#define CYCLE_MAX     (128*NB_ITERATION)

#define LABEL(str...)							\
  {									\
    msg (_("{%d} "),static_cast<uint32_t>(sc_simulation_time()));	\
    msg (str);								\
    msg (_("\n"));							\
  } while(0)

#define SC_START(cycle_offset)                                                       \
  do									             \
    {									             \
      /*cout << "SC_START (begin)" << endl;*/				             \
									             \
      uint32_t cycle_current = static_cast<uint32_t>(sc_simulation_time());          \
      if (cycle_offset != 0)						             \
	{								             \
	  cout << "##########[ cycle "<< cycle_current+cycle_offset << " ]" << endl; \
	}								             \
									             \
      if (cycle_current > CYCLE_MAX)					             \
	{								             \
	  TEST_KO("Maximal cycles Reached");				             \
	}								             \
									             \
      sc_start(cycle_offset);						             \
									             \
      /*cout << "SC_START (end  )" << endl;*/				             \
    } while(0)

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Branch_Target_Buffer * _Branch_Target_Buffer = new Branch_Target_Buffer (name.c_str(),
#ifdef STATISTICS
					     _parameters_statistics,
#endif
					     _param);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL           ," in_PREDICT_VAL           ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK           ,"out_PREDICT_ACK           ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_CONTEXT_ID    ," in_PREDICT_CONTEXT_ID    ",Tcontext_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_ADDRESS       ," in_PREDICT_ADDRESS       ",Tgeneral_data_t    ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_HIT           ,"out_PREDICT_HIT           ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_SRC   ,"out_PREDICT_ADDRESS_SRC   ",Tgeneral_data_t    ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ADDRESS_DEST  ,"out_PREDICT_ADDRESS_DEST  ",Tgeneral_data_t    ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_CONDITION     ,"out_PREDICT_CONDITION     ",Tbranch_condition_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_LAST_TAKE     ,"out_PREDICT_LAST_TAKE     ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_IS_ACCURATE   ,"out_PREDICT_IS_ACCURATE   ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_DECOD_VAL             ," in_DECOD_VAL             ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ACK             ,"out_DECOD_ACK             ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONTEXT_ID      ," in_DECOD_CONTEXT_ID      ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ADDRESS_SRC     ," in_DECOD_ADDRESS_SRC     ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_ADDRESS_DEST    ," in_DECOD_ADDRESS_DEST    ",Tgeneral_data_t    ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONDITION       ," in_DECOD_CONDITION       ",Tbranch_condition_t,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_LAST_TAKE       ," in_DECOD_LAST_TAKE       ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_MISS_PREDICTION ," in_DECOD_MISS_PREDICTION ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_UPDATE_VAL            ," in_UPDATE_VAL            ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_ACK            ,"out_UPDATE_ACK            ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_CONTEXT_ID     ," in_UPDATE_CONTEXT_ID     ",Tcontext_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ADDRESS_SRC    ," in_UPDATE_ADDRESS_SRC    ",Tgeneral_data_t    ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ADDRESS_DEST   ," in_UPDATE_ADDRESS_DEST   ",Tgeneral_data_t    ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_CONDITION      ," in_UPDATE_CONDITION      ",Tbranch_condition_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_LAST_TAKE      ," in_UPDATE_LAST_TAKE      ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_MISS_PREDICTION," in_UPDATE_MISS_PREDICTION",Tcontrol_t         ,_param->_nb_inst_update);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Branch_Target_Buffer.\n"),name.c_str());

  (*(_Branch_Target_Buffer->in_CLOCK))        (*(in_CLOCK));
  (*(_Branch_Target_Buffer->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_PREDICT_VAL           ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_ACK           ,_param->_nb_inst_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_PREDICT_CONTEXT_ID    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_PREDICT_ADDRESS       ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_HIT           ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_ADDRESS_SRC   ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_ADDRESS_DEST  ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_CONDITION     ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_LAST_TAKE     ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_PREDICT_IS_ACCURATE   ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_VAL             ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_DECOD_ACK             ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_CONTEXT_ID      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_ADDRESS_SRC     ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_ADDRESS_DEST    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_CONDITION       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_LAST_TAKE       ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_DECOD_MISS_PREDICTION ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_VAL            ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer,out_UPDATE_ACK            ,_param->_nb_inst_update);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_CONTEXT_ID     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_ADDRESS_SRC    ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_ADDRESS_DEST   ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_CONDITION      ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_LAST_TAKE      ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Branch_Target_Buffer, in_UPDATE_MISS_PREDICTION,_param->_nb_inst_update);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);

      SC_START(1);
    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  delete []  in_PREDICT_VAL           ;
  delete [] out_PREDICT_ACK           ;
  delete []  in_PREDICT_CONTEXT_ID    ;
  delete []  in_PREDICT_ADDRESS       ;
  delete [] out_PREDICT_HIT           ;
  delete [] out_PREDICT_ADDRESS_SRC   ;
  delete [] out_PREDICT_ADDRESS_DEST  ;
  delete [] out_PREDICT_CONDITION     ;
  delete [] out_PREDICT_LAST_TAKE     ;
  delete [] out_PREDICT_IS_ACCURATE   ;
  
  delete []  in_DECOD_VAL             ;
  delete [] out_DECOD_ACK             ;
  delete []  in_DECOD_CONTEXT_ID      ;
  delete []  in_DECOD_ADDRESS_SRC     ;
  delete []  in_DECOD_ADDRESS_DEST    ;
  delete []  in_DECOD_CONDITION       ;
  delete []  in_DECOD_LAST_TAKE       ;
  delete []  in_DECOD_MISS_PREDICTION ;
  
  delete []  in_UPDATE_VAL            ;
  delete [] out_UPDATE_ACK            ;
  delete []  in_UPDATE_CONTEXT_ID     ;
  delete []  in_UPDATE_ADDRESS_SRC    ;
  delete []  in_UPDATE_ADDRESS_DEST   ;
  delete []  in_UPDATE_CONDITION      ;
  delete []  in_UPDATE_LAST_TAKE      ;
  delete []  in_UPDATE_MISS_PREDICTION;
#endif

  delete _Branch_Target_Buffer;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
