#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_branch_target_buffer_Parameters_h

/*
 * $Id: Parameters.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/include/Parameters.h"

#include "Behavioural/Generic/Sort/include/Parameters.h"
#include "Behavioural/Generic/Victim/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Register/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {

  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : uint32_t   _nb_context     ;
  public : uint32_t * _nb_instruction ;
  public : uint32_t   _size_buffer    ;
  public : uint32_t   _associativity  ;
  public : uint32_t   _size_address   ;
  public : uint32_t   _size_counter   ;
  public : uint32_t   _nb_inst_predict;
  public : uint32_t   _nb_inst_decod  ;
  public : uint32_t   _nb_inst_update ;
  public : Tvictim_t  _victim_scheme  ;

  public : uint32_t   _size_bank      ;
  public : uint32_t   _size_context_id;
  public : uint32_t   _size_victim    ;

  public : bool       _have_port_context_id;
  public : bool       _have_component_victim;
  public : bool       _is_full_associative;

  public : morpheo::behavioural::generic::sort::Parameters   * _param_sort;
  public : morpheo::behavioural::generic::victim::Parameters * _param_victim;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_glue::Parameters     * _param_branch_target_buffer_glue;
  public : morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::branch_target_buffer_register::Parameters * _param_branch_target_buffer_register;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (uint32_t   nb_context     ,
			uint32_t * nb_instruction ,
			uint32_t   size_buffer    ,
			uint32_t   associativity  ,
			uint32_t   size_address   ,
			uint32_t   size_counter   ,
			uint32_t   nb_inst_predict,
			uint32_t   nb_inst_decod  ,
			uint32_t   nb_inst_update ,
			Tvictim_t  victim_scheme  );
//   public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public :        Parameters_test msg_error  (void);

  public :        std::string     print      (uint32_t depth);
  public : friend std::ostream&   operator<< (std::ostream& output_stream,
					    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::Parameters & x);
  };

}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
