#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Parameters_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_direction_meta_predictor_two_level_branch_predictor_Parameters_h

/*
 * $Id: Parameters.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Common/include/Debug.h"
#include "Behavioural/include/Parameters.h"
// Internal structure
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Branch_History_Table/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Pattern_History_Table/include/Parameters.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Direction/Meta_Predictor/Two_Level_Branch_Predictor/Two_Level_Branch_Predictor_Glue/include/Parameters.h"
#include <math.h>

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace direction {

namespace meta_predictor {
namespace two_level_branch_predictor {


  class Parameters : public morpheo::behavioural::Parameters
  {
    //-----[ fields ]------------------------------------------------------------
  public : const bool     _have_bht              ;
  public : const uint32_t _bht_size_shifter      ;
  public : const uint32_t _bht_nb_shifter        ;
  public : const bool     _have_pht              ;
  public : const uint32_t _pht_size_counter      ;
  public : const uint32_t _pht_nb_counter        ;
  public : const uint32_t _pht_size_address_share;
  public : const uint32_t _size_address          ;
  public : const uint32_t _nb_prediction         ;
  public : const uint32_t _nb_branch_complete    ;
    
  public : const uint32_t _bht_size_address  ;
  public : const uint32_t _pht_size_address  ;

  public :       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::branch_history_table ::Parameters * _param_branch_history_table;
  public :       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::pattern_history_table::Parameters * _param_pattern_history_table;
  public :       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::two_level_branch_predictor_glue::Parameters * _param_two_level_branch_predictor_glue;

    //-----[ methods ]-----------------------------------------------------------
  public : Parameters  (bool     have_bht              ,
			uint32_t bht_size_shifter      ,
			uint32_t bht_nb_shifter        ,
			bool     have_pht              ,
			uint32_t pht_size_counter      ,
			uint32_t pht_nb_counter        ,
			uint32_t pht_size_address_share,
			uint32_t size_address          ,
			uint32_t nb_prediction         ,
			uint32_t nb_branch_complete    );

  public : Parameters  (Parameters & param) ;
  public : ~Parameters () ;

  public : string msg_error (void);

  public :        string   print      (uint32_t depth);
  public : friend ostream& operator<< (ostream& output_stream,
				       morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::direction::meta_predictor::two_level_branch_predictor::Parameters & x);
  };

}; // end namespace two_level_branch_predictor
}; // end namespace meta_predictor

}; // end namespace core
}; // end namespace multi_front_end
}; // end namespace front_end
}; // end namespace prediction_unit
}; // end namespace direction

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
