/*
 * $Id$
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Prediction_unit_Glue/include/Prediction_unit_Glue.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace prediction_unit_glue {


#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::Prediction_unit_Glue"
  Prediction_unit_Glue::Prediction_unit_Glue 
  (
#ifdef SYSTEMC
   sc_module_name name,
#else
   string name,
#endif
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::prediction_unit_glue::Parameters * param,
   morpheo::behavioural::Tusage_t usage
   ):
    _name              (name)
    ,_param            (param)
    ,_usage            (usage)
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

    usage_environment(_usage);

    log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Allocation");

    allocation (
#ifdef STATISTICS
		param_statistics
#endif
		);

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {	
	log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Allocation of statistics");

	statistics_allocation(param_statistics);
      }
#endif

#ifdef VHDL
    if (usage_is_set(_usage,USE_VHDL))
      {
	// generate the vhdl
	log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Generate the vhdl");
	
	vhdl();
      }
#endif

#ifdef SYSTEMC
    if (usage_is_set(_usage,USE_SYSTEMC))
      {
	log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Method - transition");

	SC_METHOD (transition);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).pos();
	
# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
# endif    

	log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Method - genMealy_predict");

	SC_METHOD (genMealy_predict);
	dont_initialize ();
	sensitive << (*(in_CLOCK)).neg(); // use internal register
	for (uint32_t i=0; i<_param->_nb_context; i++)
	  {
	    sensitive << (*( in_PREDICT_VAL                         [i]))
		      << (*( in_PREDICT_PC_PREVIOUS                 [i]))
		      << (*( in_PREDICT_PC_CURRENT                  [i]))
		      << (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	  }
	for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	  {
	    sensitive << (*( in_PREDICT_BTB_ACK              [i]))
		      << (*( in_PREDICT_BTB_HIT              [i]))
		      << (*( in_PREDICT_BTB_ADDRESS_SRC      [i]))
		      << (*( in_PREDICT_BTB_ADDRESS_DEST     [i]))
		      << (*( in_PREDICT_BTB_CONDITION        [i]))
// 		      << (*( in_PREDICT_BTB_LAST_TAKE        [i]))
		      << (*( in_PREDICT_BTB_IS_ACCURATE      [i]))
		      << (*( in_PREDICT_DIR_ACK              [i]))
// 		      << (*( in_PREDICT_DIR_HISTORY          [i]))
		      << (*( in_PREDICT_DIR_DIRECTION        [i]))
		      << (*( in_PREDICT_RAS_ACK              [i]))
		      << (*( in_PREDICT_RAS_HIT              [i]))
		      << (*( in_PREDICT_RAS_ADDRESS_POP      [i]))
// 		      << (*( in_PREDICT_RAS_INDEX            [i]))
		      << (*( in_PREDICT_UPT_ACK              [i]));
	  }

# ifdef SYSTEMCASS_SPECIFIC
	// List dependency information
	for (uint32_t x=0; x<_param->_nb_context; x++)
	  {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_ACK                         [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_PC_NEXT                     [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_PC_NEXT_IS_DS_TAKE          [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    if (_param->_have_port_inst_ifetch_ptr [x])
	      {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_INST_IFETCH_PTR             [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_BRANCH_STATE                [x]))(*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_BRANCH_STATE                [x]))(*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_BRANCH_STATE                [x]))(*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_BRANCH_STATE                [x]))(*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_BRANCH_STATE                [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    if (_param->_have_port_depth [x])
	      {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_BRANCH_UPDATE_PREDICTION_ID [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }
	      }

	    for (uint32_t y=0; y<_param->_nb_instruction[x]; y++)
	      {
		for (uint32_t i=0; i<_param->_nb_context; i++)
		  {
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_VAL                         [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_PC_CURRENT                  [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
		  }
		for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
		  {
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_ACK              [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_HIT              [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_DIR_ACK              [i]));
// 		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_DIR_HISTORY          [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_RAS_ACK              [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_RAS_HIT              [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_RAS_INDEX            [i]));
		    (*(out_PREDICT_INSTRUCTION_ENABLE          [x][y])) (*( in_PREDICT_UPT_ACK              [i]));
		  }
	      }
	  }

	for (uint32_t x=0; x<_param->_nb_inst_predict; x++)
	  {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_BTB_VAL              [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_BTB_CONTEXT_ID       [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_BTB_ADDRESS          [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_DIR_VAL              [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_DIR_ADDRESS_SRC      [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_DIR_STATIC           [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

// 	    for (uint32_t i=0; i<_param->_nb_context; i++)
// 	      {
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_VAL                         [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
// 	      }
// 	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
// 	      {
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_ACK              [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_HIT              [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// // 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_DIR_ACK              [i]));
// // 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_RAS_ACK              [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_RAS_HIT              [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// // 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_RAS_INDEX            [i]));
// 		(*(out_PREDICT_DIR_LAST_TAKE        [x])) (*( in_PREDICT_UPT_ACK              [i]));
// 	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_RAS_VAL              [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_RAS_CONTEXT_ID       [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_RAS_PUSH             [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_RAS_ADDRESS_PUSH     [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_VAL              [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    if (_param->_have_port_context_id)
	      {
	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_CONTEXT_ID       [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_SRC  [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_BTB_ADDRESS_DEST [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_BTB_CONDITION    [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_BTB_LAST_TAKE    [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_BTB_IS_ACCURATE  [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

// 	    for (uint32_t i=0; i<_param->_nb_context; i++)
// 	      {
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_VAL                         [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
// 	      }
// 	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
// 	      {
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_ACK              [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_HIT              [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// // 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_DIR_ACK              [i]));
// // 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_RAS_ACK              [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_RAS_HIT              [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// // 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_RAS_INDEX            [i]));
// 		(*(out_PREDICT_UPT_DIR_HISTORY      [x])) (*( in_PREDICT_UPT_ACK              [i]));
// 	      }

	    for (uint32_t i=0; i<_param->_nb_context; i++)
	      {
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_VAL                         [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
	      }
	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
	      {
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_ACK              [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_HIT              [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// 		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_DIR_ACK              [i]));
// 		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_RAS_ACK              [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_RAS_HIT              [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// 		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_RAS_INDEX            [i]));
		(*(out_PREDICT_UPT_RAS_ADDRESS      [x])) (*( in_PREDICT_UPT_ACK              [i]));
	      }

// 	    for (uint32_t i=0; i<_param->_nb_context; i++)
// 	      {
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_VAL                         [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_PC_PREVIOUS                 [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_PC_CURRENT                  [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_PC_CURRENT_IS_DS_TAKE       [i]));
// 	      }
// 	    for (uint32_t i=0; i<_param->_nb_inst_predict; i++)
// 	      {
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_ACK              [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_HIT              [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_ADDRESS_SRC      [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_ADDRESS_DEST     [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_CONDITION        [i]));
// // 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_LAST_TAKE        [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_BTB_IS_ACCURATE      [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_DIR_ACK              [i]));
// // 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_DIR_HISTORY          [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_DIR_DIRECTION        [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_RAS_ACK              [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_RAS_HIT              [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_RAS_ADDRESS_POP      [i]));
// // 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_RAS_INDEX            [i]));
// 		(*(out_PREDICT_UPT_RAS_INDEX        [x])) (*( in_PREDICT_UPT_ACK              [i]));
// 	      }
	  }
# endif    
	
#endif
      }
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };
    
#undef  FUNCTION
#define FUNCTION "Prediction_unit_Glue::~Prediction_unit_Glue"
  Prediction_unit_Glue::~Prediction_unit_Glue (void)
  {
    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"Begin");

#ifdef STATISTICS
    if (usage_is_set(_usage,USE_STATISTICS))
      {
	statistics_deallocation();
      }
#endif

    log_printf(INFO,Prediction_unit_Glue,FUNCTION,"Deallocation");
    deallocation ();

    log_printf(FUNC,Prediction_unit_Glue,FUNCTION,"End");
  };

}; // end namespace prediction_unit_glue
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
