/*
 * $Id: test.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 * Test
 */

#define NB_ITERATION  8
#define CYCLE_MAX     (128*NB_ITERATION)

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/SelfTest/include/test.h"
#include "Common/include/Test.h"
#include "Behavioural/include/Allocation.h"

void test (string name,
	   morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters * _param)
{
  msg(_("<%s> : Simulation SystemC.\n"),name.c_str());

#ifdef STATISTICS
  morpheo::behavioural::Parameters_Statistics * _parameters_statistics = new morpheo::behavioural::Parameters_Statistics (5,50);
#endif

  Tusage_t _usage = USE_ALL;

//   _usage = usage_unset(_usage,USE_SYSTEMC              );
//   _usage = usage_unset(_usage,USE_VHDL                 );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH       );
//   _usage = usage_unset(_usage,USE_VHDL_TESTBENCH_ASSERT);
//   _usage = usage_unset(_usage,USE_POSITION             );
//   _usage = usage_unset(_usage,USE_STATISTICS           );
//   _usage = usage_unset(_usage,USE_INFORMATION          );
    
  Update_Prediction_Table * _Update_Prediction_Table = new Update_Prediction_Table 
    (name.c_str(),
#ifdef STATISTICS
     _parameters_statistics,
#endif
     _param,
     _usage);
  
#ifdef SYSTEMC
  /*********************************************************************
   * Dclarations des signaux
   *********************************************************************/
  string rename;

  sc_clock              *  in_CLOCK  = new sc_clock ("clock", 1.0, 0.5);	 
  sc_signal<Tcontrol_t> *  in_NRESET = new sc_signal<Tcontrol_t> ("NRESET");

  ALLOC1_SC_SIGNAL( in_PREDICT_VAL                    ," in_PREDICT_VAL                    ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL(out_PREDICT_ACK                    ,"out_PREDICT_ACK                    ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_CONTEXT_ID             ," in_PREDICT_CONTEXT_ID             ",Tcontext_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_SRC        ," in_PREDICT_BTB_ADDRESS_SRC        ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_ADDRESS_DEST       ," in_PREDICT_BTB_ADDRESS_DEST       ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_CONDITION          ," in_PREDICT_BTB_CONDITION          ",Tbranch_condition_t,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_LAST_TAKE          ," in_PREDICT_BTB_LAST_TAKE          ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_BTB_IS_ACCURATE        ," in_PREDICT_BTB_IS_ACCURATE        ",Tcontrol_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_DIR_HISTORY            ," in_PREDICT_DIR_HISTORY            ",Thistory_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_ADDRESS            ," in_PREDICT_RAS_ADDRESS            ",Taddress_t         ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_PREDICT_RAS_INDEX              ," in_PREDICT_RAS_INDEX              ",Tptr_t             ,_param->_nb_inst_predict);
//ALLOC1_SC_SIGNAL(out_PREDICT_UPDATE_PREDICTION_ID   ,"out_PREDICT_UPDATE_PREDICTION_ID   ",Tprediction_ptr_t  ,_param->_nb_inst_predict);
  ALLOC1_SC_SIGNAL( in_DECOD_VAL                      ," in_DECOD_VAL                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL(out_DECOD_ACK                      ,"out_DECOD_ACK                      ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_CONTEXT_ID               ," in_DECOD_CONTEXT_ID               ",Tcontext_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_ADDRESS_SRC          ," in_DECOD_BTB_ADDRESS_SRC          ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_ADDRESS_DEST         ," in_DECOD_BTB_ADDRESS_DEST         ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_CONDITION            ," in_DECOD_BTB_CONDITION            ",Tbranch_condition_t,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_BTB_LAST_TAKE            ," in_DECOD_BTB_LAST_TAKE            ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_ADDRESS              ," in_DECOD_RAS_ADDRESS              ",Taddress_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_RAS_INDEX                ," in_DECOD_RAS_INDEX                ",Tptr_t             ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_MISS_PREDICTION          ," in_DECOD_MISS_PREDICTION          ",Tcontrol_t         ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_DECOD_UPDATE_PREDICTION_ID     ," in_DECOD_UPDATE_PREDICTION_ID     ",Tprediction_ptr_t  ,_param->_nb_inst_decod);
//ALLOC1_SC_SIGNAL(out_DECOD_DEPTH                    ,"out_DECOD_DEPTH                    ",Tdepth_t           ,_param->_nb_inst_decod);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_VAL            ," in_BRANCH_COMPLETE_VAL            ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ACK            ,"out_BRANCH_COMPLETE_ACK            ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_CONTEXT_ID     ," in_BRANCH_COMPLETE_CONTEXT_ID     ",Tcontext_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_DEPTH          ," in_BRANCH_COMPLETE_DEPTH          ",Tdepth_t           ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_ADDRESS        ," in_BRANCH_COMPLETE_ADDRESS        ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL( in_BRANCH_COMPLETE_FLAG           ," in_BRANCH_COMPLETE_FLAG           ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_MISS_PREDICTION,"out_BRANCH_COMPLETE_MISS_PREDICTION",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_TAKE           ,"out_BRANCH_COMPLETE_TAKE           ",Tcontrol_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_SRC    ,"out_BRANCH_COMPLETE_ADDRESS_SRC    ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_BRANCH_COMPLETE_ADDRESS_DEST   ,"out_BRANCH_COMPLETE_ADDRESS_DEST   ",Taddress_t         ,_param->_nb_inst_branch_complete);
  ALLOC1_SC_SIGNAL(out_UPDATE_VAL                     ,"out_UPDATE_VAL                     ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL( in_UPDATE_ACK                     ," in_UPDATE_ACK                     ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_CONTEXT_ID              ,"out_UPDATE_CONTEXT_ID              ",Tcontext_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_MISS_PREDICTION         ,"out_UPDATE_MISS_PREDICTION         ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIRECTION_GOOD          ,"out_UPDATE_DIRECTION_GOOD          ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_VAL                 ,"out_UPDATE_BTB_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_SRC         ,"out_UPDATE_BTB_ADDRESS_SRC         ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_ADDRESS_DEST        ,"out_UPDATE_BTB_ADDRESS_DEST        ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_BTB_CONDITION           ,"out_UPDATE_BTB_CONDITION           ",Tbranch_condition_t,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIR_VAL                 ,"out_UPDATE_DIR_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_DIR_HISTORY             ,"out_UPDATE_DIR_HISTORY             ",Thistory_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_VAL                 ,"out_UPDATE_RAS_VAL                 ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_ADDRESS             ,"out_UPDATE_RAS_ADDRESS             ",Taddress_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_INDEX               ,"out_UPDATE_RAS_INDEX               ",Tptr_t             ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_UPDATE_RAS_PREDICTION_IFETCH   ,"out_UPDATE_RAS_PREDICTION_IFETCH   ",Tcontrol_t         ,_param->_nb_inst_update);
  ALLOC1_SC_SIGNAL(out_DEPTH_NB_BRANCH                ,"out_DEPTH_NB_BRANCH                ",Tdepth_t           ,_param->_nb_context);
  ALLOC1_SC_SIGNAL(out_DEPTH_TAIL                     ,"out_DEPTH_TAIL                     ",Tdepth_t           ,_param->_nb_context);
  
  /********************************************************
   * Instanciation
   ********************************************************/
  
  msg(_("<%s> : Instanciation of _Update_Prediction_Table.\n"),name.c_str());

  (*(_Update_Prediction_Table->in_CLOCK))        (*(in_CLOCK));
  (*(_Update_Prediction_Table->in_NRESET))       (*(in_NRESET));

  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_VAL                    ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_PREDICT_ACK                    ,_param->_nb_inst_predict);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_CONTEXT_ID             ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_ADDRESS_SRC        ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_ADDRESS_DEST       ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_CONDITION          ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_LAST_TAKE          ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_BTB_IS_ACCURATE        ,_param->_nb_inst_predict);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_DIR_HISTORY            ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_RAS_ADDRESS            ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_PREDICT_RAS_INDEX              ,_param->_nb_inst_predict);
//if (_param->_have_port_depth)
//INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_PREDICT_UPDATE_PREDICTION_ID   ,_param->_nb_inst_predict);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_VAL                      ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DECOD_ACK                      ,_param->_nb_inst_decod);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_CONTEXT_ID               ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_ADDRESS_SRC          ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_ADDRESS_DEST         ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_CONDITION            ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_BTB_LAST_TAKE            ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_RAS_ADDRESS              ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_RAS_INDEX                ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_MISS_PREDICTION          ,_param->_nb_inst_decod);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_DECOD_UPDATE_PREDICTION_ID     ,_param->_nb_inst_decod);
//if (_param->_have_port_depth)
//INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DECOD_DEPTH                    ,_param->_nb_inst_decod);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_VAL            ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ACK            ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_CONTEXT_ID     ,_param->_nb_inst_branch_complete);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_DEPTH          ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_ADDRESS        ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_BRANCH_COMPLETE_FLAG           ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_MISS_PREDICTION,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_TAKE           ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ADDRESS_SRC    ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_BRANCH_COMPLETE_ADDRESS_DEST   ,_param->_nb_inst_branch_complete);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_VAL                     ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table, in_UPDATE_ACK                     ,_param->_nb_inst_update);
  if (_param->_have_port_context_id)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_CONTEXT_ID              ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_MISS_PREDICTION         ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIRECTION_GOOD          ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_VAL                 ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_ADDRESS_SRC         ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_ADDRESS_DEST        ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_BTB_CONDITION           ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIR_VAL                 ,_param->_nb_inst_update);
  if (_param->_have_port_history)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_DIR_HISTORY             ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_VAL                 ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_ADDRESS             ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_INDEX               ,_param->_nb_inst_update);
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_UPDATE_RAS_PREDICTION_IFETCH   ,_param->_nb_inst_update);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DEPTH_NB_BRANCH                ,_param->_nb_context);
  if (_param->_have_port_depth)
  INSTANCE1_SC_SIGNAL(_Update_Prediction_Table,out_DEPTH_TAIL                     ,_param->_nb_context);

  msg(_("<%s> : Start Simulation ............\n"),name.c_str());
    
  Time * _time = new Time();

  /********************************************************
   * Simulation - Begin
   ********************************************************/

  // Initialisation

  const uint32_t seed = 0;
//const uint32_t seed = static_cast<uint32_t>(time(NULL));

  srand(seed);

  const  int32_t percent_transaction_predict         = 75;
  const  int32_t percent_transaction_decod           = 75;
  const  int32_t percent_transaction_branch_complete = 75;
  const  int32_t percent_transaction_update          = 75;

  SC_START(0);
  LABEL("Initialisation");

  LABEL("Reset");
  in_NRESET->write(0);
  SC_START(5);
  in_NRESET->write(1);  

  LABEL("Loop of Test");

  for (uint32_t iteration=0; iteration<NB_ITERATION; iteration ++)
    {
      LABEL("Iteration %d",iteration);
      
      {
	uint32_t context = rand() % _param->_nb_context;
	
// 	LABEL("KANE : %d",context);

	LABEL("PREDICT - fill the queue");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_predict;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      
	      bool find = false;
	      do
		{
		  in_PREDICT_VAL              [port]->write((rand()%100)<percent_transaction_predict);
		  in_PREDICT_CONTEXT_ID       [port]->write(context);
		  in_PREDICT_BTB_ADDRESS_SRC  [port]->write(0xdeadbeef+i);
		  in_PREDICT_BTB_ADDRESS_DEST [port]->write(0x21071981+i);
		  in_PREDICT_BTB_CONDITION    [port]->write(BRANCH_CONDITION_FLAG_SET);
		  in_PREDICT_BTB_LAST_TAKE    [port]->write(1);
		  in_PREDICT_BTB_IS_ACCURATE  [port]->write((rand()%100)<percent_transaction_predict);
		  in_PREDICT_DIR_HISTORY      [port]->write(i);
		  in_PREDICT_RAS_ADDRESS      [port]->write(0xdeaddead+i);
		  in_PREDICT_RAS_INDEX        [port]->write((0x12345678+i)%_param->_size_ras_index[context]);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), i);
		    }
		  SC_START(0);
		  
		  LABEL("PREDICT         [%d] %d - %d (accurate : %d).",port,in_PREDICT_VAL [port]->read(),out_PREDICT_ACK [port]->read(), in_PREDICT_BTB_IS_ACCURATE [port]->read());
		  
		  if (in_PREDICT_VAL [port]->read() and out_PREDICT_ACK [port]->read())
		    {
		      LABEL("PREDICT         [%d] - Transaction accepted",port);
		      find = true;
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_PREDICT_VAL              [port]->write(0);
	      
	      if (_param->_have_port_depth)
		{
		  TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		  TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), i+1);
		}
	    }
	}
	
	LABEL("DECOD - hit ifetch");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_decod;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      
	      bool find = false;
	      do
		{
		  in_DECOD_VAL                  [port]->write((rand()%100)<percent_transaction_decod);
		  in_DECOD_CONTEXT_ID           [port]->write(context);
		  in_DECOD_BTB_ADDRESS_SRC      [port]->write(0xdeadbeef+i);
		  in_DECOD_BTB_ADDRESS_DEST     [port]->write(0x21071981+i);
		  in_DECOD_BTB_CONDITION        [port]->write(BRANCH_CONDITION_FLAG_SET);
		  in_DECOD_BTB_LAST_TAKE        [port]->write(1);
		  in_DECOD_RAS_ADDRESS          [port]->write(0xdeaddead+i);
		  in_DECOD_RAS_INDEX            [port]->write((0x12345678+i)%_param->_size_ras_index[context]);
		  in_DECOD_MISS_PREDICTION      [port]->write(false);
		  in_DECOD_UPDATE_PREDICTION_ID [port]->write(i);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		    }
		  
		  SC_START(0);
		  
		  LABEL("DECOD           [%d] %d - %d.",port,in_DECOD_VAL [port]->read(),out_DECOD_ACK [port]->read());
		  
		  if (in_DECOD_VAL [port]->read() and out_DECOD_ACK [port]->read())
		    {
		      LABEL("DECOD           [%d] - Transaction accepted",port);
		      find = true;
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_DECOD_VAL              [port]->write(0);
	      
	      if (_param->_have_port_depth)
		{
		  TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		  TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		}
	    }
	}
	
	LABEL("BRANCH_COMPLETE - hit ifetch");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_branch_complete;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      bool find = false;
	      do
		{
		  in_BRANCH_COMPLETE_VAL                  [port]->write((rand()%100)<percent_transaction_branch_complete);
		  in_BRANCH_COMPLETE_CONTEXT_ID           [port]->write(context);
		  in_BRANCH_COMPLETE_DEPTH                [port]->write(i);
		  in_BRANCH_COMPLETE_ADDRESS              [port]->write(0xcacacaca+i);
		  in_BRANCH_COMPLETE_FLAG                 [port]->write(1);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		    }
		  
		  SC_START(0);
		  
		  LABEL("BRANCH_COMPLETE [%d] %d - %d.",port,in_BRANCH_COMPLETE_VAL [port]->read(),out_BRANCH_COMPLETE_ACK [port]->read());
		  
		  if (in_BRANCH_COMPLETE_VAL [port]->read() and out_BRANCH_COMPLETE_ACK [port]->read())
		    {
		      LABEL("BRANCH_COMPLETE [%d] - Transaction accepted",port);
		      find = true;
		      
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_MISS_PREDICTION[port]->read(),0);
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_TAKE           [port]->read(),1);
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_SRC    [port]->read(),0xdeadbeef+i);
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_DEST   [port]->read(),0x21071981+i);
		    }
		  
		  SC_START(1);

		} while (not find);
	      in_BRANCH_COMPLETE_VAL              [port]->write(0);
	      
	      if (_param->_have_port_depth)
		{
		  TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		  TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		}
	    }
	}
	
	LABEL("UPDATE - hit ifetch");
	
	{
	  uint32_t port = 0; //rand() % _param->_nb_inst_update;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      bool find = false;
	      do
		{
		  in_UPDATE_ACK [port]->write((rand()%100)<percent_transaction_update);
		  
		  SC_START(0);
		  
		  if (out_UPDATE_VAL [port]->read() and in_UPDATE_ACK [port]->read())
		    {
		      LABEL("UPDATE [%d] - Transaction accepted",port);
		      
		      find = true;
		      
		      TEST(Tcontext_t         ,out_UPDATE_CONTEXT_ID            [port]->read(), context);
		      TEST(Tcontrol_t         ,out_UPDATE_MISS_PREDICTION       [port]->read(), 0);
		      TEST(Tcontrol_t         ,out_UPDATE_DIRECTION_GOOD        [port]->read(), 1);
		      TEST(Tcontrol_t         ,out_UPDATE_BTB_VAL               [port]->read(), 1);
		      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_SRC       [port]->read(), 0xdeadbeef+i);
		      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_DEST      [port]->read(), 0x21071981+i);	      
		      TEST(Tbranch_condition_t,out_UPDATE_BTB_CONDITION         [port]->read(), BRANCH_CONDITION_FLAG_SET);
		      TEST(Tcontrol_t         ,out_UPDATE_DIR_VAL               [port]->read(), 1);
		      if (_param->_have_port_history)
			TEST(Thistory_t         ,out_UPDATE_DIR_HISTORY           [port]->read(), i);
		      TEST(Tcontrol_t         ,out_UPDATE_RAS_VAL               [port]->read(), 0);
		      TEST(Taddress_t         ,out_UPDATE_RAS_ADDRESS           [port]->read(), 0xdeaddead+i);
		      TEST(Tptr_t             ,out_UPDATE_RAS_INDEX             [port]->read(), (0x12345678+i)%_param->_size_ras_index[context]);
		      TEST(Tcontrol_t         ,out_UPDATE_RAS_PREDICTION_IFETCH [port]->read(), 1);
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_UPDATE_ACK              [port]->write(0);
	    }
	  
	  LABEL("Wait a moment");
	  SC_START(2*_param->_size_queue[context]);
  
	  // wait the garbage collector
	  if (_param->_have_port_depth)
	    while ((out_DEPTH_TAIL     [context]->read() != 0) and
		   (out_DEPTH_NB_BRANCH[context]->read() != 0))
	      {
		LABEL("DEPTH [%d] nb_branch : %d - tail : %d",context,out_DEPTH_NB_BRANCH[context]->read(), out_DEPTH_TAIL [context]->read());
		SC_START(1);
	      }
	}
      }

      {
	uint32_t context = rand() % _param->_nb_context;
	
// 	LABEL("KANE : %d",context);

	LABEL("PREDICT - fill the queue");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_predict;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      
	      bool find = false;
	      do
		{
		  in_PREDICT_VAL              [port]->write((rand()%100)<percent_transaction_predict);
		  in_PREDICT_CONTEXT_ID       [port]->write(context);
		  in_PREDICT_BTB_ADDRESS_SRC  [port]->write(0xdeadbeef+i);
		  in_PREDICT_BTB_ADDRESS_DEST [port]->write(0x21071981+i);
		  in_PREDICT_BTB_CONDITION    [port]->write(BRANCH_CONDITION_FLAG_SET);
		  in_PREDICT_BTB_LAST_TAKE    [port]->write(1);
		  in_PREDICT_BTB_IS_ACCURATE  [port]->write((rand()%100)<percent_transaction_predict);
		  in_PREDICT_DIR_HISTORY      [port]->write(i);
		  in_PREDICT_RAS_ADDRESS      [port]->write(0xdeaddead+i);
		  in_PREDICT_RAS_INDEX        [port]->write((0x12345678+i)%_param->_size_ras_index[context]);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), i);
		    }
		  SC_START(0);
		  
		  LABEL("PREDICT         [%d] %d - %d (accurate : %d).",port,in_PREDICT_VAL [port]->read(),out_PREDICT_ACK [port]->read(), in_PREDICT_BTB_IS_ACCURATE [port]->read());
		  
		  if (in_PREDICT_VAL [port]->read() and out_PREDICT_ACK [port]->read())
		    {
		      LABEL("PREDICT         [%d] - Transaction accepted",port);
		      find = true;
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_PREDICT_VAL              [port]->write(0);
	      
	      if (_param->_have_port_depth)
		{
		  TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		  TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), i+1);
		}
	    }
	}
	
	LABEL("DECOD - hit ifetch");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_decod;
	  
	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      
	      bool find = false;
	      do
		{
		  in_DECOD_VAL                  [port]->write((rand()%100)<percent_transaction_decod);
		  in_DECOD_CONTEXT_ID           [port]->write(context);
		  in_DECOD_BTB_ADDRESS_SRC      [port]->write(0xdeadbeef+i);
		  in_DECOD_BTB_ADDRESS_DEST     [port]->write(0x21071981+i);
		  in_DECOD_BTB_CONDITION        [port]->write(BRANCH_CONDITION_FLAG_SET);
		  in_DECOD_BTB_LAST_TAKE        [port]->write(1);
		  in_DECOD_RAS_ADDRESS          [port]->write(0xdeaddead+i);
		  in_DECOD_RAS_INDEX            [port]->write((0x12345678+i)%_param->_size_ras_index[context]);
		  in_DECOD_MISS_PREDICTION      [port]->write(false);
		  in_DECOD_UPDATE_PREDICTION_ID [port]->write(i);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		    }
		  
		  SC_START(0);
		  
		  LABEL("DECOD           [%d] %d - %d.",port,in_DECOD_VAL [port]->read(),out_DECOD_ACK [port]->read());
		  
		  if (in_DECOD_VAL [port]->read() and out_DECOD_ACK [port]->read())
		    {
		      LABEL("DECOD           [%d] - Transaction accepted",port);
		      find = true;
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_DECOD_VAL              [port]->write(0);
	      
	      if (_param->_have_port_depth)
		{
		  TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		  TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		}
	    }
	}
	
	LABEL("BRANCH_COMPLETE - hit ifetch");
	
	{
	  uint32_t port = rand() % _param->_nb_inst_branch_complete;
	  
	    {
	      uint32_t i=0;
	      bool find = false;
	      do
		{
		  in_BRANCH_COMPLETE_VAL                  [port]->write((rand()%100)<percent_transaction_branch_complete);
		  in_BRANCH_COMPLETE_CONTEXT_ID           [port]->write(context);
		  in_BRANCH_COMPLETE_DEPTH                [port]->write(i);
		  in_BRANCH_COMPLETE_ADDRESS              [port]->write(0xcacacaca+i);
		  in_BRANCH_COMPLETE_FLAG                 [port]->write(0);
		  
		  if (_param->_have_port_depth)
		    {
		      TEST(Tdepth_t,out_DEPTH_TAIL     [context]->read(), 0);
		      TEST(Tdepth_t,out_DEPTH_NB_BRANCH[context]->read(), _param->_size_queue[context]);
		    }
		  
		  SC_START(0);
		  
		  LABEL("BRANCH_COMPLETE [%d] %d - %d.",port,in_BRANCH_COMPLETE_VAL [port]->read(),out_BRANCH_COMPLETE_ACK [port]->read());
		  
		  if (in_BRANCH_COMPLETE_VAL [port]->read() and out_BRANCH_COMPLETE_ACK [port]->read())
		    {
		      LABEL("BRANCH_COMPLETE [%d] - Transaction accepted",port);
		      find = true;
		      
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_MISS_PREDICTION[port]->read(),1);
		      TEST(Tcontrol_t,out_BRANCH_COMPLETE_TAKE           [port]->read(),0);
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_SRC    [port]->read(),0xdeadbeef+i);
		      TEST(Taddress_t,out_BRANCH_COMPLETE_ADDRESS_DEST   [port]->read(),0x21071981+i);
		    }
		  
		  SC_START(1);

		} while (not find);
	      in_BRANCH_COMPLETE_VAL              [port]->write(0);
	    }
	}
	
	LABEL("UPDATE - miss ifetch");
	
	{
	  uint32_t port = 0; //rand() % _param->_nb_inst_update;
	  
// 	  for (uint32_t i=0; i<_param->_size_queue[context]; i++)
	    {
	      uint32_t i=0;

	      bool find = false;
	      do
		{
		  in_UPDATE_ACK [port]->write((rand()%100)<percent_transaction_update);
		  
		  SC_START(0);
		  
		  if (out_UPDATE_VAL [port]->read() and in_UPDATE_ACK [port]->read())
		    {
		      LABEL("UPDATE [%d] - Transaction accepted",port);
		      
		      find = true;
		      
		      TEST(Tcontext_t         ,out_UPDATE_CONTEXT_ID            [port]->read(), context);
		      TEST(Tcontrol_t         ,out_UPDATE_MISS_PREDICTION       [port]->read(), 1);
		      TEST(Tcontrol_t         ,out_UPDATE_DIRECTION_GOOD        [port]->read(), 0);
		      TEST(Tcontrol_t         ,out_UPDATE_BTB_VAL               [port]->read(), 1);
		      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_SRC       [port]->read(), 0xdeadbeef+i);
		      TEST(Taddress_t         ,out_UPDATE_BTB_ADDRESS_DEST      [port]->read(), 0x21071981+i);	      
		      TEST(Tbranch_condition_t,out_UPDATE_BTB_CONDITION         [port]->read(), BRANCH_CONDITION_FLAG_SET);
		      TEST(Tcontrol_t         ,out_UPDATE_DIR_VAL               [port]->read(), 1);
		      if (_param->_have_port_history)
			TEST(Thistory_t         ,out_UPDATE_DIR_HISTORY           [port]->read(), i);
		      TEST(Tcontrol_t         ,out_UPDATE_RAS_VAL               [port]->read(), 0);
		      TEST(Taddress_t         ,out_UPDATE_RAS_ADDRESS           [port]->read(), 0xdeaddead+i);
		      TEST(Tptr_t             ,out_UPDATE_RAS_INDEX             [port]->read(), (0x12345678+i)%_param->_size_ras_index[context]);
		      TEST(Tcontrol_t         ,out_UPDATE_RAS_PREDICTION_IFETCH [port]->read(), 1);
		    }
		  
		  SC_START(1);
		  
		} while (not find);
	      in_UPDATE_ACK              [port]->write(0);
	    }
	    
	    LABEL("Wait a moment");
	    SC_START(_param->_size_queue[context]);
	    
	    // wait the garbage collector
	    if (_param->_have_port_depth)
	      while ((out_DEPTH_TAIL     [context]->read() != 0) and
		     (out_DEPTH_NB_BRANCH[context]->read() != 0))
		{
		  LABEL("DEPTH [%d] nb_branch : %d - tail : %d",context,out_DEPTH_NB_BRANCH[context]->read(), out_DEPTH_TAIL [context]->read());
		  SC_START(1);
		}
	}
      }

      LABEL ("Yo1");
      SC_START(1);
      LABEL ("Yo2");

    }

  /********************************************************
   * Simulation - End
   ********************************************************/

  TEST_OK ("End of Simulation");
  delete _time;

  msg(_("<%s> : ............ Stop Simulation\n"),name.c_str());

  delete in_CLOCK;
  delete in_NRESET;

  // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_PREDICT_VAL                 ;
  delete [] out_PREDICT_ACK                 ;
  delete []  in_PREDICT_CONTEXT_ID          ;
  delete []  in_PREDICT_BTB_ADDRESS_SRC     ;
  delete []  in_PREDICT_BTB_ADDRESS_DEST    ;
  delete []  in_PREDICT_BTB_CONDITION       ;
  delete []  in_PREDICT_BTB_LAST_TAKE       ;
  delete []  in_PREDICT_BTB_IS_ACCURATE     ;
  delete []  in_PREDICT_DIR_HISTORY         ;
  delete []  in_PREDICT_RAS_ADDRESS         ;
  delete []  in_PREDICT_RAS_INDEX           ;
//delete [] out_PREDICT_UPDATE_PREDICTION_ID;
  
  // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_DECOD_VAL                   ;
  delete [] out_DECOD_ACK                   ;
  delete []  in_DECOD_CONTEXT_ID            ;
  delete []  in_DECOD_BTB_ADDRESS_SRC       ;
  delete []  in_DECOD_BTB_ADDRESS_DEST      ;
  delete []  in_DECOD_BTB_CONDITION         ;
  delete []  in_DECOD_BTB_LAST_TAKE         ;
  delete []  in_DECOD_RAS_ADDRESS           ;
  delete []  in_DECOD_RAS_INDEX             ;
  delete []  in_DECOD_MISS_PREDICTION       ;
  delete []  in_DECOD_UPDATE_PREDICTION_ID  ;
//delete [] out_DECOD_DEPTH                 ;
  
  // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete []  in_BRANCH_COMPLETE_VAL            ;
  delete [] out_BRANCH_COMPLETE_ACK            ;
  delete []  in_BRANCH_COMPLETE_CONTEXT_ID     ;
  delete []  in_BRANCH_COMPLETE_DEPTH          ;
  delete []  in_BRANCH_COMPLETE_ADDRESS        ;
  delete []  in_BRANCH_COMPLETE_FLAG           ;
  delete [] out_BRANCH_COMPLETE_MISS_PREDICTION;
  delete [] out_BRANCH_COMPLETE_TAKE           ;
  delete [] out_BRANCH_COMPLETE_ADDRESS_SRC    ;
  delete [] out_BRANCH_COMPLETE_ADDRESS_DEST   ;
  
  // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete [] out_UPDATE_VAL                  ;
  delete []  in_UPDATE_ACK                  ;
  delete [] out_UPDATE_CONTEXT_ID           ;
  delete [] out_UPDATE_MISS_PREDICTION      ;
  delete [] out_UPDATE_DIRECTION_GOOD       ;
  delete [] out_UPDATE_BTB_VAL              ;
  delete [] out_UPDATE_BTB_ADDRESS_SRC      ;
  delete [] out_UPDATE_BTB_ADDRESS_DEST     ;
  delete [] out_UPDATE_BTB_CONDITION        ;
  delete [] out_UPDATE_DIR_VAL              ;
  delete [] out_UPDATE_DIR_HISTORY          ;
  delete [] out_UPDATE_RAS_VAL              ;
  delete [] out_UPDATE_RAS_ADDRESS          ;
  delete [] out_UPDATE_RAS_INDEX            ;
  delete [] out_UPDATE_RAS_PREDICTION_IFETCH;

  // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  delete [] out_DEPTH_NB_BRANCH;
  delete [] out_DEPTH_TAIL;

#endif

  delete _Update_Prediction_Table;
#ifdef STATISTICS
  delete _parameters_statistics;
#endif
}
