#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Types_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Types_h

/*
 * $Id: Types.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Types.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {

  typedef enum
    {
      UPDATE_PREDICTION_STATE_EMPTY      , // Slot is empty
      UPDATE_PREDICTION_STATE_WAIT_DECOD , // Fetch have access at the predictor
      UPDATE_PREDICTION_STATE_WAITEND    , // Have make a prediction, wait branch_complete
      UPDATE_PREDICTION_STATE_OK         , // branch is complete and can update predictor
      UPDATE_PREDICTION_STATE_KO         , // have a event - must update predictor unit
      UPDATE_PREDICTION_STATE_END          // branch is updated 
    } state_t;

  class entry_t
  {
  public : state_t             _state;
  public : Tcontrol_t          _ifetch_prediction;
  public : Tbranch_condition_t _condition;
  public : Taddress_t          _address_src;
  public : Taddress_t          _address_dest;
  public : Tcontrol_t          _last_take;
  public : Tcontrol_t          _good_take;
  public : Thistory_t          _history;
  public : Taddress_t          _address_ras;
  public : Tptr_t              _index_ras;
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
  

  template<> inline std::string toString<morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::state_t>(const morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::state_t& x)
  {
    switch (x)
      {
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_EMPTY      : return "empty"     ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_WAIT_DECOD : return "wait_decod"; break;
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_WAITEND    : return "waitend"   ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_OK         : return "ok"        ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_KO         : return "ko"        ; break;
      case morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::UPDATE_PREDICTION_STATE_END        : return "end"       ; break;
      default    : return ""      ; break;
      }
  };


}; // end namespace morpheo              

#endif
