#ifndef morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Update_Prediction_Table_h
#define morpheo_behavioural_core_multi_front_end_front_end_prediction_unit_update_prediction_table_Update_Prediction_Table_h

/*
 * $Id: Update_Prediction_Table.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Types.h"
#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace update_prediction_table {


  class Update_Prediction_Table 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface : "predict" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_VAL                 ; //[nb_inst_predict]
  public    : SC_OUT(Tcontrol_t         )  ** out_PREDICT_ACK                 ; //[nb_inst_predict]
  public    : SC_IN (Tcontext_t         )  **  in_PREDICT_CONTEXT_ID          ; //[nb_inst_predict]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_BTB_ADDRESS_SRC     ; //[nb_inst_predict]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_BTB_ADDRESS_DEST    ; //[nb_inst_predict]
  public    : SC_IN (Tbranch_condition_t)  **  in_PREDICT_BTB_CONDITION       ; //[nb_inst_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_LAST_TAKE       ; //[nb_inst_predict]
  public    : SC_IN (Tcontrol_t         )  **  in_PREDICT_BTB_IS_ACCURATE     ; //[nb_inst_predict]
  public    : SC_IN (Thistory_t         )  **  in_PREDICT_DIR_HISTORY         ; //[nb_inst_predict]
  public    : SC_IN (Taddress_t         )  **  in_PREDICT_RAS_ADDRESS         ; //[nb_inst_predict]
  public    : SC_IN (Tptr_t             )  **  in_PREDICT_RAS_INDEX           ; //[nb_inst_predict]
//public    : SC_OUT(Tprediction_ptr_t  )  ** out_PREDICT_UPDATE_PREDICTION_ID; //[nb_inst_predict]

    // ~~~~~[ Interface : "decod" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_VAL                   ; //[nb_inst_decod]
  public    : SC_OUT(Tcontrol_t         )  ** out_DECOD_ACK                   ; //[nb_inst_decod]
  public    : SC_IN (Tcontext_t         )  **  in_DECOD_CONTEXT_ID            ; //[nb_inst_decod]
  public    : SC_IN (Taddress_t         )  **  in_DECOD_BTB_ADDRESS_SRC       ; //[nb_inst_decod]
  public    : SC_IN (Taddress_t         )  **  in_DECOD_BTB_ADDRESS_DEST      ; //[nb_inst_decod]
  public    : SC_IN (Tbranch_condition_t)  **  in_DECOD_BTB_CONDITION         ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_BTB_LAST_TAKE         ; //[nb_inst_decod]
//public    : SC_IN (Tcontrol_t         )  **  in_DECOD_BTB_IS_ACCURATE       ; //[nb_inst_decod]
//public    : SC_IN (Thistory_t         )  **  in_DECOD_DIR_HISTORY           ; //[nb_inst_decod] // if ifetch prediction is miss -> miss btb -> make a static state
  public    : SC_IN (Taddress_t         )  **  in_DECOD_RAS_ADDRESS           ; //[nb_inst_decod]
  public    : SC_IN (Tptr_t             )  **  in_DECOD_RAS_INDEX             ; //[nb_inst_decod]
  public    : SC_IN (Tcontrol_t         )  **  in_DECOD_MISS_PREDICTION       ; //[nb_inst_decod] // ifetch is a miss pred
  public    : SC_IN (Tprediction_ptr_t  )  **  in_DECOD_UPDATE_PREDICTION_ID  ; //[nb_inst_decod]
//public    : SC_OUT(Tdepth_t           )  ** out_DECOD_DEPTH                 ; //[nb_inst_decod]

    // ~~~~~[ Interface : "branch_complete" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_VAL            ; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_ACK            ; //[nb_inst_branch_complete]
  public    : SC_IN (Tcontext_t         )  **  in_BRANCH_COMPLETE_CONTEXT_ID     ; //[nb_inst_branch_complete]
  public    : SC_IN (Tdepth_t           )  **  in_BRANCH_COMPLETE_DEPTH          ; //[nb_inst_branch_complete]
  public    : SC_IN (Taddress_t         )  **  in_BRANCH_COMPLETE_ADDRESS        ; //[nb_inst_branch_complete]
  public    : SC_IN (Tcontrol_t         )  **  in_BRANCH_COMPLETE_FLAG           ; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_MISS_PREDICTION; //[nb_inst_branch_complete]
  public    : SC_OUT(Tcontrol_t         )  ** out_BRANCH_COMPLETE_TAKE           ; //[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_COMPLETE_ADDRESS_SRC    ; //[nb_inst_branch_complete]
  public    : SC_OUT(Taddress_t         )  ** out_BRANCH_COMPLETE_ADDRESS_DEST   ; //[nb_inst_branch_complete]

    // ~~~~~[ Interface : "update" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_VAL                  ; //[nb_inst_update]
  public    : SC_IN (Tcontrol_t         )  **  in_UPDATE_ACK                  ; //[nb_inst_update]
  public    : SC_OUT(Tcontext_t         )  ** out_UPDATE_CONTEXT_ID           ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_MISS_PREDICTION      ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_DIRECTION_GOOD       ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_BTB_VAL              ; //[nb_inst_update]
  public    : SC_OUT(Taddress_t         )  ** out_UPDATE_BTB_ADDRESS_SRC      ; //[nb_inst_update]
  public    : SC_OUT(Taddress_t         )  ** out_UPDATE_BTB_ADDRESS_DEST     ; //[nb_inst_update]
  public    : SC_OUT(Tbranch_condition_t)  ** out_UPDATE_BTB_CONDITION        ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_DIR_VAL              ; //[nb_inst_update]
  public    : SC_OUT(Thistory_t         )  ** out_UPDATE_DIR_HISTORY          ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_VAL              ; //[nb_inst_update]
  public    : SC_OUT(Taddress_t         )  ** out_UPDATE_RAS_ADDRESS          ; //[nb_inst_update]
  public    : SC_OUT(Tptr_t             )  ** out_UPDATE_RAS_INDEX            ; //[nb_inst_update]
  public    : SC_OUT(Tcontrol_t         )  ** out_UPDATE_RAS_PREDICTION_IFETCH; //[nb_inst_update]

    // ~~~~~[ Interface : "depth" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_NB_BRANCH; //[nb_context]
  public    : SC_OUT(Tdepth_t           )  ** out_DEPTH_TAIL; //[nb_context]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
  private   : uint32_t                      * reg_TOP                    ; //[nb_context]
  private   : uint32_t                      * reg_BOTTOM                 ; //[nb_context]
  private   : uint32_t                      * reg_NB_ELT                 ; //[nb_context]
  private   : uint32_t                      * reg_NB_ELT_NEED_UPDATE     ; //[nb_context]
  private   : entry_t                      ** reg_UPDATE_PREDICTION_TABLE; //[nb_context][size_queue]
  private   : uint32_t                        reg_UPDATE_PRIORITY        ;

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : Tcontrol_t                    * internal_PREDICT_ACK                    ; //[nb_inst_predict]
  private   : Tcontrol_t                    * internal_DECOD_ACK                      ; //[nb_inst_decod]
  private   : Tcontrol_t                    * internal_BRANCH_COMPLETE_ACK            ; //[nb_inst_branch_complete]
  private   : Tcontrol_t                    * internal_BRANCH_COMPLETE_MISS_PREDICTION; //[nb_inst_branch_complete]
  private   : Tcontrol_t                    * internal_BRANCH_COMPLETE_TAKE           ; //[nb_inst_branch_complete]
  private   : Taddress_t                    * internal_BRANCH_COMPLETE_ADDRESS_DEST   ; //[nb_inst_branch_complete]
  private   : Tcontrol_t                    * internal_UPDATE_VAL                     ; //[nb_inst_update]
  private   : Tcontext_t                    * internal_UPDATE_CONTEXT_ID              ; //[nb_inst_update]
  private   : Tdepth_t                      * internal_UPDATE_DEPTH                   ; //[nb_inst_update]
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Update_Prediction_Table);
#endif
  public  :          Update_Prediction_Table              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage
   );
  public  :          ~Update_Prediction_Table             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMoore                  (void);
  public  : void        genMealy_predict          (void);
  public  : void        genMealy_decod            (void);
  public  : void        genMealy_branch_complete  (void);
//public  : void        genMealy_update           (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_allocation     (morpheo::behavioural::Parameters_Statistics * param_statistics);
  public  : void        statistics_deallocation   (void);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace update_prediction_table
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
