/*
 * $Id: Stat_List_unit_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Stat_List_unit/include/Stat_List_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace stat_list_unit {



#undef  FUNCTION
#define FUNCTION "Stat_List_unit::allocation"
  void Stat_List_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Stat_List_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Stat_List_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

     // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("insert",IN,SOUTH,"Insert a renaming result",_param->_nb_inst_insert);

       ALLOC1_VALACK_IN ( in_INSERT_VAL               ,VAL);
       ALLOC1_VALACK_OUT(out_INSERT_ACK               ,ACK);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_INSERT_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_INSERT_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register);
     }

     // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("retire",IN,NORTH,"Retire a renaming result",_param->_nb_inst_retire);

       ALLOC1_VALACK_IN ( in_RETIRE_VAL               ,VAL);
       ALLOC1_VALACK_OUT(out_RETIRE_ACK               ,ACK);
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RA           ,"read_ra"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RA_PHY    ,"num_reg_ra_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RB           ,"read_rb"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RB_PHY    ,"num_reg_rb_phy"    ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_READ_RC           ,"read_rc"           ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RC_PHY    ,"num_reg_rc_phy"    ,Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RD          ,"write_rd"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_OLD,"num_reg_rd_phy_old",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RD_PHY_NEW,"num_reg_rd_phy_new",Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_WRITE_RE          ,"write_re"          ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_OLD,"num_reg_re_phy_old",Tspecial_address_t,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_RETIRE_NUM_REG_RE_PHY_NEW,"num_reg_re_phy_new",Tspecial_address_t,_param->_size_special_register);
     }

     // ~~~~~[ interface : "push_gpr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("push_gpr",OUT,SOUTH,"Free a general register",_param->_nb_reg_free);

       ALLOC1_VALACK_OUT(out_PUSH_GPR_VAL    ,VAL);
       ALLOC1_VALACK_IN ( in_PUSH_GPR_ACK    ,ACK);
       ALLOC1_SIGNAL_OUT(out_PUSH_GPR_NUM_REG,"num_reg",Tgeneral_address_t,_param->_size_general_register);
     }

     // ~~~~~[ interface : "push_spr" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("push_spr",OUT,SOUTH,"Free a special register",_param->_nb_reg_free);

       ALLOC1_VALACK_OUT(out_PUSH_SPR_VAL    ,VAL);
       ALLOC1_VALACK_IN ( in_PUSH_SPR_ACK    ,ACK);
       ALLOC1_SIGNAL_OUT(out_PUSH_SPR_NUM_REG,"num_reg",Tspecial_address_t,_param->_size_special_register);
     }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     gpr_stat_list = new stat_list_entry_t * [_param->_nb_bank];
     spr_stat_list = new stat_list_entry_t * [_param->_nb_bank];

     for (uint32_t i=0; i<_param->_nb_bank; i++)
       {
	 gpr_stat_list [i] = new stat_list_entry_t [_param->_nb_general_register_by_bank];
	 spr_stat_list [i] = new stat_list_entry_t [_param->_nb_special_register_by_bank];
       }       

     internal_INSERT_ACK        = new Tcontrol_t [_param->_nb_inst_insert];
     internal_RETIRE_ACK        = new Tcontrol_t [_param->_nb_inst_retire];
     internal_PUSH_GPR_VAL      = new Tcontrol_t [_param->_nb_reg_free];
     internal_PUSH_GPR_NUM_BANK = new uint32_t   [_param->_nb_reg_free];
     internal_PUSH_SPR_VAL      = new Tcontrol_t [_param->_nb_reg_free];
     internal_PUSH_SPR_NUM_BANK = new uint32_t   [_param->_nb_reg_free];

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Stat_List_unit,FUNCTION,"End");
  };

}; // end namespace stat_list_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
