#ifdef SYSTEMC
/*
 * $Id: Rename_select_transition.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Rename_select.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


#undef  FUNCTION
#define FUNCTION "Rename_select::transition"
  void Rename_select::transition (void)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    if (PORT_READ(in_NRESET) == 0)
      {
	select.clear();
	reg_FRONT_END_PRIORITY = 0;
      }
    else
      {
	switch (_param->_priority)
	  {
	  case PRIORITY_STATIC :
	    {
	      reg_FRONT_END_PRIORITY = (reg_FRONT_END_PRIORITY+_param->_nb_front_end_select)%_param->_nb_front_end;
	      break;
	    }
	  case PRIORITY_ROUND_ROBIN :
	    {
	      reg_FRONT_END_PRIORITY = (reg_FRONT_END_PRIORITY+1)%_param->_nb_front_end;
	      break;
	    }
	  default:
	    {
	      break;
	    }
	  }

	// flush list
	select.clear();
	
	// Compute next scan order !!!
	switch (_param->_load_balancing)
	  {
	  case LOAD_BALANCING_BALANCE :
	    {
	      for (uint32_t j=0; j<_param->_max_nb_inst_decod; j++)
		for (uint32_t i=0; i<_param->_nb_front_end_select; i++)
		  {
		    uint32_t x=(reg_FRONT_END_PRIORITY+i)%_param->_nb_front_end;
		    
		    // Test valid inst_decod
		    if (j < _param->_nb_inst_decod[x])
		      select.push_back(select_t(x,j));
		  }
		  
	      break;
	    }
	  case LOAD_BALANCING_MAXIMUM_FOR_PRIORITY :
	    {

	      for (uint32_t i=0; i<_param->_nb_front_end_select; i++)
		{
		  uint32_t x=(reg_FRONT_END_PRIORITY+i)%_param->_nb_front_end;
		  
		  for (uint32_t j=0; j<_param->_nb_inst_decod[x]; j++)
		    select.push_back(select_t(x,j));
		}

	      break;
	    }
	  default :
	    {
	      break;
	    }
	  }

// #if (DEBUG >= DEBUG_TRACE)
// 	log_printf(TRACE,Rename_select,FUNCTION,"Select priority (front_end, inst_decod)");
// 	for (std::list<select_t>::iterator it=select.begin();
// 	     it != select.end();
// 	     it++)
// 	  log_printf(TRACE,Rename_select,FUNCTION,"  %d %d",it->_front_end, it->_inst_decod);
// #endif
      }
    
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
    end_cycle ();
#endif

    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
