/*
 * $Id: Victim_Pseudo_LRU.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

#ifdef SYSTEMC
  Victim_Pseudo_LRU::Victim_Pseudo_LRU (sc_module_name name,
#else
  Victim_Pseudo_LRU::Victim_Pseudo_LRU (std::string name,
#endif
#ifdef STATISTICS
			  morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
			  morpheo::behavioural::generic::victim::victim_pseudo_lru::Parameters * param ):
			  _name   (name)
			  ,_param (param)
  {
    log_printf(FUNC,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Begin");

#ifdef SYSTEMC
    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Allocation");
    allocation ();
#endif

#ifdef STATISTICS
    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Allocation of statistics");
    
    // Allocation of statistics
    statistics_declaration(param_statistics);
#endif

#ifdef VHDL
    // generate the vhdl
    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Generation of VHDL");
    vhdl();
#endif

#ifdef SYSTEMC
    log_printf(TRACE,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","Definition of sc_method");
    SC_METHOD (transition);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).pos();

    SC_METHOD (genMoore);
    dont_initialize ();
    sensitive << (*(in_CLOCK)).neg();

#ifdef SYSTEMCASS_SPECIFIC
#endif    

    // Constant - ack is always at one
    for (uint32_t i=0; i<_param->_nb_access; i++)
      {
	internal_ACCESS_ACK [i] = 1;
	PORT_WRITE (out_ACCESS_ACK [i], internal_ACCESS_ACK [i]);
      }

#endif
    log_printf(FUNC,Victim_Pseudo_LRU,"Victim_Pseudo_LRU","End");
  };
  
  Victim_Pseudo_LRU::~Victim_Pseudo_LRU (void)
  {
    log_printf(FUNC,Victim_Pseudo_LRU,"~Victim_Pseudo_LRU","Begin");
#ifdef SYSTEMC
    deallocation ();
#endif

#ifdef STATISTICS
    delete _stat;
#endif
    log_printf(FUNC,Victim_Pseudo_LRU,"~Victim_Pseudo_LRU","End");
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
