#!/bin/sh

SED_SCRIPT=".sed_script";
SED_FILE=".sed_file";
SOURCE_FILE="New_Component";
SOURCE_DIR="./$SOURCE_FILE";
TMP_DIR="/tmp/$SOURCE_FILE"

TYPE=("vbe" "vst");

#-----[ usage ]------------------------------------------------------
#input  : -
#output : -

function usage ()
{
    echo "";
    echo "usage : $0 <directory> <name>";
    echo " - <directory> : localisation of component";
    echo " - <name>      : name of component";
    echo " - <type>      : type of component : ${TYPE[@]}";
    echo "";
    echo " Note : This script must be execute in directory's script";
    echo "";
    
    exit;
}

#-----[ test_usage ]-------------------------------------------------
#input  : all parameters
#output : -

function test_usage ()
{
    if test   -d $TMP_DIR; then
	echo "Temporary directory \"$TMP_DIR\" exist already";
	usage;
    fi;

    if test -f $SED_SCRIPT; then
	echo "File \"$SED_SCRIPT\" exist"; 
	usage;
    fi;
    if test -f $SED_FILE; then
	echo "File \"$SED_FILE\" exist"; 
	usage;
    fi;

    if test $# -ne 3; then
	usage;
    fi;

    find=0;
    for type in ${TYPE[@]}; do
	if test "$3" = "$type"; then
	    find=1;
	    SOURCE_DIR=$SOURCE_DIR"_"$type;
	fi;
    done;
    
    if test $find -eq 0; then
	usage;
    fi;

    if test ! -d $SOURCE_DIR; then
	echo "Source directory \"$SOURCE_DIR\" invalid";
	usage;
    fi;

#    if test -d $1/$2; then
#	echo "Component in Directory \"$1/$2\" already exist";
#	usage;
#    fi;
}

#-----[ rename_file ]------------------------------------------------
#input  : file_old name_old name_new
#output : -

function rename_file ()
{
    FILE_OLD=$1;
    NAME_OLD=$2;
    NAME_NEW=$3;

    FILE_NEW="`dirname  $FILE_OLD`/`basename $FILE_OLD |sed s/"$NAME_OLD"/"$NAME_NEW"/`";

    if test $FILE_NEW != $FILE_OLD; then
	mv $FILE_OLD $FILE_NEW;
    fi;
}

#-----[ rename_directory ]-------------------------------------------
#input  : dir name_old name_new
#output : -

function rename_directory ()
{
    NAME_OLD=$2;
    NAME_NEW=$3;

    # recursion
    for ENTRY in $1/*; do

	if test -d $ENTRY; then
	    rename_directory $ENTRY $2 $3;
	else
	    rename_file      $ENTRY $2 $3;
	fi;
    done;
}

#-----[ directory_to ]-----------------------------------------------
#input  : directory cmd
#output : -

function directory_to ()
{
    res="";

    for i in `echo "$1" |tr \/ ' '`; do
	j=`echo $i |tr [:upper:]  [:lower:]`;
	case $2 in
	    "dir_morpheo")
		if test -z "$res"; then
		    res="..\/..";
		else
		    res="..\/$res";
		fi;
		;;
	    "component_lower")
		res="$j";
		;;
	    "component")
		res="$i";
		;;
	    "directory")
		if test -z "$res"; then
		    res=$i;
		else
		    res="$res\/$i";
		fi;
		;;
	    "define")
		if test -z "$res"; then
		    res=$j;
		else
		    res="${res}_${j}";
		fi;
		;;
	    "namespace_begin")
		prefixe="namespace ";
		postfixe=" {\n";
		if test -z "$res"; then
		    res="$prefixe$j$postfixe";
		else
		    res="$res$prefixe$j$postfixe";
		fi;
		;;
	    "namespace_end")
		prefixe="}; \/\/ end namespace ";
		postfixe="\n";
		if test -z "$res"; then
		    res="$prefixe$j$postfixe";
		else
		    res="$prefixe$j$postfixe$res";
		fi;
		;;
	    "namespace_use")
		if test -z "$res"; then
		    res="$j";
		else
		    res="$res::$j";
		fi;
		;;
	    "namespace_using")
		prefixe="using namespace morpheo::behavioural::";
		postfixe=";\n";
		if test -z "$res"; then
		    res="$prefixe$j$postfixe";
		    namespace="$j";
		else
		    res="$res$prefixe$namespace::$j$postfixe";
		    namespace="$namespace::$j";
		fi;
		;;
	    *)
	esac;
    done;

    echo $res;
}

#-----[ translation_script ]-----------------------------------------
#input  : dir component 
#output : -

function translation_script ()
{
    #All example is the component Generic/RegisterFile
    
    #@DIR_MORPHEO	../../
    SED=`directory_to $1/$2 "dir_morpheo"`;
    echo "s/@DIR_MORPHEO/$SED/g" >> $SED_SCRIPT;

    #@COMPONENT_LOWER	registerfile
    SED=`directory_to $2 "component_lower"`;
    echo "s/@COMPONENT_LOWER/$SED/g" >> $SED_SCRIPT;

    #@COMPONENT		RegisterFile
    SED=`directory_to $2 "component"`;
    echo "s/@COMPONENT/$SED/g" >> $SED_SCRIPT;

    #@DIRECTORY		Generic/RegisterFile
    SED=`directory_to $1/$2 "directory"`;
    echo "s/@DIRECTORY/$SED/g" >> $SED_SCRIPT;

    #@DEFINE		generic_registerfile		
    SED=`directory_to $1/$2 "define"`;
    echo "s/@DEFINE/$SED/g" >> $SED_SCRIPT;

    #@NAMESPACE_BEGIN	namespace generic                    {		
    #			namespace registerfile               {		
    SED=`directory_to $1/$2 "namespace_begin"`;
    echo "s/@NAMESPACE_BEGIN/$SED/g" >> $SED_SCRIPT;

    #@NAMESPACE_END	}; // end namespace registerfile 		
    #			}; // end namespace generic			
    SED=`directory_to $1/$2 "namespace_end"`;
    echo "s/@NAMESPACE_END/$SED/g" >> $SED_SCRIPT;

    #@NAMESPACE_USE	generic::registerfile		
    SED=`directory_to $1/$2 "namespace_use"`;
    echo "s/@NAMESPACE_USE/$SED/g" >> $SED_SCRIPT;

    #@NAMESPACE_USING	using namespace morpheo::behavioural::generic;	
    SED=`directory_to $1    "namespace_using"`;
    echo "s/@NAMESPACE_USING/$SED/g" >> $SED_SCRIPT;

}



#-----[ translation_file ]-------------------------------------------
#input  : file
#output : -

function translation_file ()
{
    echo "Translation     : $1";
    
    cat $1 |sed -f $SED_SCRIPT $1 > $SED_FILE;
    mv $SED_FILE $1;
}

#-----[ translation_directory_rec ]----------------------------------
#input  : dir
#output : -

function translation_directory_rec
{
    if test `ls $1|grep -c ""` -ne 0; then
	# recursion
	for ENTRY in $1/*; do
	
		if test -d $ENTRY; then
		    translation_directory_rec $ENTRY;
		else
		    translation_file          $ENTRY
		fi;
	done;
     fi;
}

#-----[ translation_directory ]--------------------------------------
#input  : dir component
#output : -

function translation_directory ()
{
    touch $SED_SCRIPT;

    translation_script        $1 $2;  
    translation_directory_rec $1/$2;

    #cat   $SED_SCRIPT;
    rm    $SED_SCRIPT;
}


#-----[ main ]-------------------------------------------------------
#input  : all parameters
#output : -

function main ()
{
    test_usage $*;

    echo "New             : $2";
    
    # Create directory
    mkdir -p $1/$2;
    
    #Copy
    cp -r $SOURCE_DIR $TMP_DIR;
    find  $TMP_DIR   -iname ".svn" -type d -exec rm -fr '{}' \; &> /dev/null
    mv    $TMP_DIR/* $1/$2;
    rmdir $TMP_DIR
    
    #translation
    rename_directory      "$1/$2" $SOURCE_FILE $2;
    translation_directory $1 $2;
}

#-----[ body ]-------------------------------------------------------
main $*;
