/*
 * $Id: Component_test_map.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Component.h"

namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Component::test_map"
  bool Component::test_map (bool recursive)
  {
    return test_map (0, recursive);
  }

  bool Component::test_map (uint32_t depth, bool recursive)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string tab  = std::string(depth,'\t');
    std::string name = _entity->get_name();
    bool test_ok = true;

    if (_list_component->empty () == true)
      {
	log_printf(NONE,Behavioural,FUNCTION, "%s* Component \"%s\" is a behavioural description",tab.c_str(),name.c_str());
      }
    else
      {
	log_printf(NONE,Behavioural,FUNCTION, "%s* Component \"%s\" is a structural description",tab.c_str(),name.c_str());

	log_printf(INFO,Behavioural,FUNCTION, "%s* Test port I/O",tab.c_str());
	
	test_ok &= _entity->test_map(1,true);

	log_printf(INFO,Behavioural,FUNCTION, "%s* Test all internal component",tab.c_str());
	
	for (std::list<Tcomponent_t *>::iterator i= _list_component->begin();
	     i != _list_component->end();
	     ++i)
	  test_ok &= (*i)->_entity->test_map(1,false);

// 	if (recursive)
// 	  for (std::list<Tcomponent_t *>::iterator i= _list_component->begin();
// 	       i != _list_component->end();
// 	       ++i)
// 	    test_ok &= (*i)->_component->test_map(1,recursive);
      }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");
    
    if (test_ok == false)
      throw (ERRORMORPHEO (FUNCTION,"A lot of port is not connected."));

    return test_ok;
  };


}; // end namespace behavioural          
}; // end namespace morpheo              
