#ifdef VHDL

/*
 * $Id: Vhdl_get_model.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/include/Vhdl.h"

#include <sstream>

namespace morpheo              {
namespace behavioural          {
  
  std::string Vhdl::get_model(uint32_t depth            ,
			 std::string   filename         ,
			 std::string   entity_name      ,
			 std::string   architecture_name)
  {
    log_printf(FUNC,Behavioural,"get_model","Begin");

    std::string        tab = std::string(depth,'\t');
    std::ostringstream text;

    text << tab << get_header       (depth,filename)                      << std::endl
	 << tab << get_library_ieee (depth)                               << std::endl
	 << tab << get_library_work (depth)                               << std::endl
	 << tab << get_entity       (depth,entity_name)                   << std::endl
	 << tab << get_architecture (depth,architecture_name,entity_name) << std::endl;
    
    log_printf(FUNC,Behavioural,"get_model","End");

    return text.str();
  };
  
}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
