#ifndef morpheo_Log2
#define morpheo_Log2

/*
 * $Id: Log2.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <math.h>

namespace morpheo              {

  inline uint32_t log2 (uint32_t value)
  {
    return static_cast<uint32_t>(ceil(::log2(value)));
  }

  inline bool is_log2 (uint32_t value)
  {
    return (value == static_cast<uint32_t>((1<<(morpheo::log2(value)))));
  }

}; // end namespace morpheo              

#endif
