/*
 *
 * [desc.]
 */
#include "Tools/Viewer/Parser/include/parser.h"
#include "qfileinfo.h"
namespace morpheo{
namespace tools{
namespace viewer{
namespace parser{

   int Parse::open_file(string name,int level){
     
     bool pere=false;
    QFile file(QString::fromStdString(name));
    QFileInfo info(file);
    QString testname;
    absolutePath=info.absolutePath().toStdString();
    absolutePath.append("/");
    testname=info.baseName();
    if(testname.contains('-') && level==0) //file not top level (first open file)
      {
	testname=testname.left(testname.lastIndexOf('-',-1,Qt::CaseSensitive));
      }
    else
      pere=true;
    
    
     if( !file.open( QIODevice::ReadOnly ) )
       {
	 cerr << "Position File :: Failed to load file : \"" << name << "\".\n";
	 return -1;
       }

     QDomDocument doc( "pos" );
     if( !doc.setContent( &file ) )
      {
	cerr <<  "Failed XML parse file.\n";
	file.close();
	return -1;
      }
     file.close();
     QDomElement root = doc.documentElement();
     if( root.tagName() != "description" )
       {
	 cerr <<"Invalid file.\n";
	 return -1;
       }
     else
       {
         #ifdef DBUG_PARSE
	 cout << "description" <<endl;
         #endif
	 //BaseP
	 if(!base){
	   base=new morpheo::tools::viewer::bdd::BaseV(); 
	   toplevel=info.baseName().toStdString();
	   if(pere==true)
	     {
	       string op="";
	       op.append(absolutePath);
	       op.append(toplevel);
	       open_file_param(op);
	     }
	 }
	 pos=new morpheo::tools::viewer::bdd::BaseP();
	 parser_pos(root.firstChild(),level);    
       }
     return 0;
   }


};//end parser
};//end viewer
};//end tools
};//end morpheo

