/********************************************
 * files               : asm_017_mul.s
 * authors             : Rosiere Mathieu
 * date                : 2006/06/20
 ********************************************
 * input               : -
 * output              : 1 test OK
 *                       0 test KO
 ********************************************
 * test                :
 * warning             : instruction ok 
 *                         l.addi
 *                         l.and
 *                         l.jal
 *                         l.jr
 ********************************************
 */
	.file	"asm_017_mul.s"
	.section .text
	.align	4

	.global _asm_017_mul
_asm_017_mul :	
	/* save context */
	l.addi	r1,r1,-16
	l.sw	0 (r1),r20
	l.sw	4 (r1),r21	
	l.sw	8 (r1),r22
	l.sw	12(r1),r23
	
	/* Return is KO (default)*/
	l.and   r11,r0,r0

	/*
	 r20 :	result
	 r21 :	operand 1
	 r22 :	operand 2
	 r23 :	result waited
	*/
	
	/* Operand 1 : positive */
	l.movhi r21,0x1234
	l.ori	r21,r21,0x5678

	/* Test 1.1 */
	l.and	r22,r0,r0
	l.and	r23,r0,r0
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,0
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 1.2 */
		
	l.ori	r22,r0,1
	l.or 	r23,r0,r21
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,1
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 1.3 */
		
	l.ori	r22,r0,2
	l.slli	r23,r21, 1
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,2
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 1.4 */
		
	l.ori	r22,r0,0x11
	l.movhi r23,0x3579
	l.ori	r23,r23,0xbdf8
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,0x11
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 1.4 */

	l.addi	r22,r0,-1
	l.movhi r23,0xedcb
	l.ori	r23,r23,0xa988

	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
/*
	l.muli	r20,r21,-1
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
*/
	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 1.5 */

	l.addi	r22,r0,-2
	
	l.movhi r23,0xdb97
	l.ori	r23,r23,0x5310

	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
/*
	l.muli	r20,r21,-2
			
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
*/
	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Operand 2 : negative */
	l.movhi r21,0xdead
	l.ori	r21,r21,0xbeaf

	/* Test 2.1 */
	l.and	r22,r0,r0
	l.and	r23,r0,r0
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,0
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 2.2 */
		
	l.ori	r22,r0,1
	l.or 	r23,r0,r21
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,1
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 2.3 */
		
	l.ori	r22,r0,2
	l.slli	r23,r21, 1
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,2
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 2.4 */
		
	l.ori	r22,r0,0x11
	l.movhi r23,0xc989
	l.ori	r23,r23,0xa99f
	
	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.muli	r20,r21,0x11
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 2.4 */

	l.addi	r22,r0,-1
	l.movhi r23,0x2152
	l.ori	r23,r23,0x4151

	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
/*
	l.muli	r20,r21,-1
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
*/
	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1

	/* Test 2.5 */

	l.addi	r22,r0,-2

	l.movhi r23,0x42a4
	l.ori	r23,r23,0x82a2

	l.mul	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
/*
	l.muli	r20,r21,-2
			
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
*/
	l.mulu	r20,r21,r22
		
	l.sfeq	r20,r23
	l.bnf	_asm_017_mul_ko
	l.nop	1
	
_asm_017_mul_ok :	
	l.addi	r11,r0,1
_asm_017_mul_ko :
	
	/* load context */
	l.lwz	r20,0 (r1)
	l.lwz	r21,4 (r1)	
	l.lwz	r22,8 (r1)
	l.lwz	r23,12(r1)
	l.jr	r9
	l.addi	r1,r1,16
