#ifndef ENVIRONMENT_CACHE_CACHE_MULTILEVEL_ACCESS_H
#define ENVIRONMENT_CACHE_CACHE_MULTILEVEL_ACCESS_H

#include "Types.h"

namespace environment {
namespace cache {
namespace cache_multilevel {

  class Access
  {
  public : uint32_t         num_port     ;
  public : type_rsp_cache_t hit          ; // result of access
  public : uint32_t         latence      ; // Latence of access
  public : uint32_t         last_nb_level; // if access is not a hit : last level of cache before a error
    
  public : Access ()
    {
      this->num_port      = 0;
      this->hit           = MISS;
      this->latence       = 0;
      this->last_nb_level = 0;
    }

  public : Access (uint32_t         num_port     ,
		   type_rsp_cache_t hit          ,
		   uint32_t         latence      ,
		   uint32_t         last_nb_level)
    {
      this->num_port      = num_port     ;
      this->hit           = hit          ;
      this->latence       = latence      ;
      this->last_nb_level = last_nb_level;
    }

    friend std::ostream& operator<< (std::ostream& output, const Access & x)
    {
      output << "[" << x.num_port << "] "  
	     << x.hit      << " " 
	     << x.latence  << " " 
	     << x.last_nb_level;
      return output;
    }
  };//Access

};

};
};
#endif
