#ifndef Environment_RamLock_H
#define Environment_RamLock_H

#include <stdint.h>
#include <iostream>

#include "RamLock_Parameters.h"

namespace environment {
namespace ramlock {

#define UNLOCK false
#define   LOCK true

  class RamLock
  {
    // field
  private : std::string   _name;
  private : Parameters  * _param;
  private : bool        * _lock;

    // method
  public  :  RamLock (std::string  name, 
		      Parameters * param);
  public  : ~RamLock (void);

//public  : bool test  (uint32_t num_lock);
  public  : void reset (void);
  public  : bool read  (uint32_t num_lock);
  public  : bool write (uint32_t num_lock);
    
  public  : friend std::ostream& operator<< (std::ostream& output, environment::ramlock::RamLock & x);
  };

};
};
#endif
