#include "../include/Cache_Access.h"

namespace environment {

  Cache_Access dreq_type2cache_type (morpheo::behavioural::Tdcache_type_t dreq_type, bool uncached)
  {
    cache::type_req_cache_t      type     ;
    cache::direction_req_cache_t direction;
    uint32_t nb_bytes = 0;
    switch (dreq_type)
      {
      case DCACHE_TYPE_LOAD_8     : direction=cache::READ ; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 1; break; 
      case DCACHE_TYPE_LOAD_16    : direction=cache::READ ; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 2; break; 
      case DCACHE_TYPE_LOAD_32    : direction=cache::READ ; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 4; break; 
      case DCACHE_TYPE_LOAD_64    : direction=cache::READ ; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 8; break; 
      case DCACHE_TYPE_INVALIDATE : direction=cache::NONE ; type=cache::INVALIDATE                        ; nb_bytes = 1; break;
      case DCACHE_TYPE_FLUSH      : direction=cache::NONE ; type=cache::FLUSH                             ; nb_bytes = 1; break;
      case DCACHE_TYPE_PREFETCH   : direction=cache::NONE ; type=cache::INVALIDATE                        ; nb_bytes = 1; break;
//    case DCACHE_TYPE_STORE_8_ACK: direction=cache::WRITE; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 1; break;
      case DCACHE_TYPE_STORE_8    : direction=cache::WRITE; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 1; break;
      case DCACHE_TYPE_STORE_16   : direction=cache::WRITE; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 2; break;
      case DCACHE_TYPE_STORE_32   : direction=cache::WRITE; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 4; break;
      case DCACHE_TYPE_STORE_64   : direction=cache::WRITE; type=((uncached==true)?cache::UNCACHED:cache::CACHED); nb_bytes = 8; break;
      case DCACHE_TYPE_LOCK            :
      case DCACHE_TYPE_SYNCHRONIZATION :
      default : {std::cerr << "<ireq_type2cache_type> Unkown type (" << dreq_type << ")" << std::endl; exit(1);}
      }
    
    return Cache_Access (type,direction,nb_bytes);
  };

};
