#include "../include/Environment.h"

namespace environment {

  void Environment::genMoore (void)
  {
    //Scan all entity and for each entity scan all port
    for (uint32_t i = 0; i < param->nb_entity; i++)
      {
	//=============================================================================
	//===== [ ICACHE ]=============================================================
	//=============================================================================
	
	//-----------------------------------------------------------------------------
	//----- [ Request ]------------------------------------------------------------
	//-----------------------------------------------------------------------------
	{
	  uint32_t nb_slot_free = component_buffer_irsp [i]->nb_slot_free ();
	  for (uint32_t j=0; j<param->icache_dedicated_nb_port [i]; j ++)
	    {
	      icache_req_ack [i][j] = (j < nb_slot_free);
	      ICACHE_REQ_ACK [i][j]->write (icache_req_ack [i][j]);
	    }
	}

	//-----------------------------------------------------------------------------
	//----- [ Respons ]------------------------------------------------------------
	//-----------------------------------------------------------------------------
	{
	  for (uint32_t j = 0; j < param->icache_dedicated_nb_port [i]; j ++)
      	    {
	      // Test the number of element in the respons's buffer
      	      if (j >= component_buffer_irsp [i]->nb_slot_use())
      		{
		  icache_rsp_val [i][j] = 0; // No respons
      		}
      	      else
      		{
		  queue::slot_t<irsp_t*> slot = component_buffer_irsp [i]->read(j);
		  
		  bool val = (slot._delay == 0);

		  icache_rsp_val [i][j] = (val); // respons if have a result

		  if (val)
		    {
		      ICACHE_RSP_CONTEXT_ID [i][j]->write(slot._data->trdid); // TODO : test if exist
		      ICACHE_RSP_PACKET_ID  [i][j]->write(slot._data->pktid); // TODO : test if exist
		      ICACHE_RSP_ERROR      [i][j]->write(slot._data->error);
		      
		      for (uint32_t k = 0; k < param->iaccess_nb_instruction[i]; k ++)
			{
			  Ticache_instruction_t data = 0;
			  
			  atoi (slot._data->data[k], data, param->iaccess_size_instruction[i]/8);
			  
			  ICACHE_RSP_INSTRUCTION [i][j][k]->write(data);
			}
		    }
		}

	      ICACHE_RSP_VAL [i][j]->write (icache_rsp_val [i][j]);
      	    }
	}
	
	//=============================================================================
	//===== [ DCACHE ]=============================================================
	//=============================================================================
	
	//-----------------------------------------------------------------------------
	//----- [ Request ]------------------------------------------------------------
	//-----------------------------------------------------------------------------
	{
	  uint32_t nb_slot_free = component_buffer_drsp [i]->nb_slot_free ();
	  for (uint32_t j = 0; j < param->dcache_dedicated_nb_port [i]; j ++)
	    {
	      dcache_req_ack [i][j] = (j < nb_slot_free);
	      DCACHE_REQ_ACK [i][j]->write (dcache_req_ack [i][j]);
	    }
	}
	
	//-----------------------------------------------------------------------------
	//----- [ Respons ]------------------------------------------------------------
	//-----------------------------------------------------------------------------
	{
	  for (uint32_t j = 0; j < param->dcache_dedicated_nb_port [i]; j ++)
      	    {
	      // Test the number of element in the respons's buffer
      	      if (j >= component_buffer_drsp [i]->nb_slot_use())
      		{
		  dcache_rsp_val [i][j] = 0; // No respons
      		}
      	      else
      		{
		  queue::slot_t<drsp_t*> slot = component_buffer_drsp [i]->read(j);

		  bool val = (slot._delay == 0); // respons if have a result
		  
		  dcache_rsp_val [i][j] = (val); // respons if have a result

		  if (val)
		    {
		      DCACHE_RSP_CONTEXT_ID [i][j]->write(slot._data->trdid); // TODO : test if exist
		      DCACHE_RSP_PACKET_ID  [i][j]->write(slot._data->pktid); // TODO : test if exist
		      DCACHE_RSP_ERROR      [i][j]->write(slot._data->error);
		      
		      Tdcache_data_t data = 0;
		      atoi (slot._data->data[0], data, param->daccess_size_data[i]/8);
		      
		      DCACHE_RSP_RDATA       [i][j]->write(data);
		    }
		}
	      DCACHE_RSP_VAL [i][j]->write (dcache_rsp_val [i][j]);
      	    }
	}
      }
  }

};
