#ifndef ACCESS_PORT_H
#define ACCESS_PORT_H

#include "address.h"
#include "type_rsp_cache.h"
#include <iostream>
using namespace std;

namespace hierarchy_memory          {
namespace cache                     {
namespace cache_multilevel          {
namespace cache_onelevel            {

  class access_port_t
    {
    public    : bool             valid;
    public    : address_t        address;
    public    : uint32_t         trdid;
    public    : type_rsp_cache_t hit;
    public    : uint32_t         num_associativity; // on hit  : update lru
    public    : uint32_t         latence;           // on miss : wait

      friend ostream& operator<< (ostream& output_stream, const access_port_t &x)
      {
	output_stream << x.valid             << " "
		      << x.hit               << " "
		      << x.address           << " "
		      << x.trdid             << " "
		      << x.num_associativity << " "
		      << x.latence;

	return output_stream;
      }

    };

};};};};

#endif //!ACCESS_PORT_H
