#ifndef ENTRY_H
#define ENTRY_H

#include <stdint.h>
#include <iostream>
using namespace std; // Utilisation de l'espace de nommage standard

namespace hierarchy_memory
{
  namespace sort_file
  {
    class Entry
    {
    public : uint32_t       trdid;  // number of thread
    public : uint32_t       pktid;  // number of packet
    public : uint64_t       data;
      
      Entry () 
      {
	trdid = 0;
	pktid = 0;
	data  = 0;
      };
      
      Entry (uint32_t       trdid ,
	     uint32_t       pktid ,
	     uint64_t       data  )
      {
	this->trdid = trdid;
	this->pktid = pktid;
	this->data  = data ;
      };
      
      friend ostream& operator<< (ostream& output_stream, Entry x)
      {
	output_stream << x.trdid << " " << x.pktid << " " << hex << x.data << dec;
	return output_stream;
      }
    };
  }; //sort_file
}; //hierarchy_memory
#endif //!ENTRY_H
