#ifdef STATISTICS
/*
 * $Id: Functionnal_unit_statistics_declaration.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Functionnal_unit/include/Functionnal_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace functionnal_unit {


#undef  FUNCTION
#define FUNCTION "Functionnal_unit::statistics_declaration"
  void Functionnal_unit::statistics_declaration (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Functionnal_unit,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Functionnal_unit",
		      param_statistics);

    _stat_use_functionnal_unit         = _stat->create_variable("use_functionnal_unit");
    _stat_average_use_functionnal_unit = _stat->create_counter ("average_use_functionnal_unit", "" , "Average by cycle of the functionnal_unit occupation.");
    _stat_percent_use_functionnal_unit = _stat->create_counter ("percent_use_functionnal_unit", "%", "Percent of functionnal_unit usage.");

    _stat->create_expr("average_use_functionnal_unit", "/ use_functionnal_unit cycle"      , false);
    _stat->create_expr("percent_use_functionnal_unit", "* average_use_functionnal_unit 100", false);

    _stat_sum_delay                    = _stat->create_variable("sum_delay");
    _stat_average_delay                = _stat->create_counter ("average_delay"               , "" , "Average by operation of the delay.");
    _stat_sum_latence                  = _stat->create_variable("sum_latence");
    _stat_average_latence              = _stat->create_counter ("average_latence"             , "" , "Average by operation of the latence.");

    _stat->create_expr("average_delay"               , "/ sum_delay   use_functionnal_unit", false);
    _stat->create_expr("average_latence"             , "/ sum_latence use_functionnal_unit", false);

    log_printf(FUNC,Functionnal_unit,FUNCTION,"End");
  };

}; // end namespace functionnal_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
