#ifdef STATISTICS
/*
 * $Id: Load_store_unit_statistics_declaration.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Execute_unit/Execute_unit/Load_store_unit/include/Load_store_unit.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_execute_unit {
namespace execute_unit {
namespace load_store_unit {


#undef  FUNCTION
#define FUNCTION "Load_store_unit::statistics_declaration"
  void Load_store_unit::statistics_declaration (morpheo::behavioural::Parameters_Statistics * param_statistics)
  {
    log_printf(FUNC,Load_store_unit,FUNCTION,"Begin");

    _stat = new Stat (static_cast<std::string>(_name),
		      "Load_store_unit",
		      param_statistics);

    _stat_use_store_queue                      = _stat->create_variable("use_store_queue");
    _stat_use_load_queue                       = _stat->create_variable("use_load_queue");
    _stat_use_speculative_access_queue         = _stat->create_variable("use_speculative_access_queue");

    _stat_average_use_store_queue              = _stat->create_counter("average_use_store_queue"              , "", "Average by cycle of the store_queue occupation ");
    _stat_average_use_load_queue               = _stat->create_counter("average_use_load_queue"               , "", "Average by cycle of the load_queue occupation");
    _stat_average_use_speculative_access_queue = _stat->create_counter("average_use_speculative_access_queue" , "", "Average by cycle of the speculative_access_queue occupation");

    _stat_percent_use_store_queue              = _stat->create_counter("percent_use_store_queue"              , "%", "Percent of store_queue usage");
    _stat_percent_use_load_queue               = _stat->create_counter("percent_use_load_queue"               , "%", "Percent of load_queue usage");
    _stat_percent_use_speculative_access_queue = _stat->create_counter("percent_use_speculative_access_queue" , "%", "Percent of speculative_access_queue usage");

    _stat->create_expr("average_use_store_queue"             , "/ use_store_queue              cycle", false);
    _stat->create_expr("average_use_load_queue"              , "/ use_load_queue               cycle", false);
    _stat->create_expr("average_use_speculative_access_queue", "/ use_speculative_access_queue cycle", false);

    _stat->create_expr("percent_use_store_queue"              , "/ * average_use_store_queue              100 " + toString(_param->_size_store_queue             ), false);
    _stat->create_expr("percent_use_load_queue"               , "/ * average_use_load_queue               100 " + toString(_param->_size_load_queue              ), false);
    _stat->create_expr("percent_use_speculative_access_queue" , "/ * average_use_speculative_access_queue 100 " + toString(_param->_size_speculative_access_queue), false);

    log_printf(FUNC,Load_store_unit,FUNCTION,"End");
  };

}; // end namespace load_store_unit
}; // end namespace execute_unit
}; // end namespace multi_execute_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
