/*
 * $Id: Read_unit_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Multi_Read_unit/Read_unit/include/Read_unit.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace multi_read_unit {
namespace read_unit {



#undef  FUNCTION
#define FUNCTION "Read_unit::allocation"
  void Read_unit::allocation (
#ifdef STATISTICS
			       morpheo::behavioural::Parameters_Statistics * param_statistics
#else
			       void
#endif
			       )
  {
    log_printf(FUNC,Read_unit,FUNCTION,"Begin");

    _component   = new Component (_usage);

    Entity * entity = _component->set_entity (_name       
					      ,"Read_unit"
#ifdef POSITION
					      ,COMBINATORY 
#endif
					      );

    _interfaces = entity->set_interfaces();

    // ~~~~~[ Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~

      Interface * interface = _interfaces->set_interface(""
#ifdef POSITION
							 ,IN
							 ,SOUTH,
							 "Generalist interface"
#endif
							 );

     in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_YES);
     in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1, RESET_VHDL_YES);

    // ~~~~~[ Interface "read_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC_INTERFACE("read_unit_in", IN, WEST, "Enter of new operation");

       ALLOC_VALACK_IN    ( in_READ_UNIT_IN_VAL,VAL);
       ALLOC_VALACK_OUT   (out_READ_UNIT_IN_ACK,ACK);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id   );
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id );
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_PACKET_ID            ,"packet_id"            ,Tpacket_t         ,_param->_size_packet_id    );
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation    );
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type         );
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,log2(_param->_size_store_queue));
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,log2(_param->_size_load_queue));
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_READ_RA              ,"read_ra"              ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_NUM_REG_RA           ,"num_reg_ra"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_READ_RB              ,"read_rb"              ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_NUM_REG_RB           ,"num_reg_rb"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_READ_RC              ,"read_rc"              ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_NUM_REG_RC           ,"num_reg_rc"           ,Tspecial_address_t,_param->_size_special_register);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1);
       ALLOC_SIGNAL_IN ( in_READ_UNIT_IN_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);
     }

    // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("read_unit_out", OUT, EAST, "Output of operation. All operand is valid.", _param->_nb_inst_retire);

       ALLOC1_VALACK_OUT   (out_READ_UNIT_OUT_VAL,VAL);
       ALLOC1_VALACK_IN    ( in_READ_UNIT_OUT_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_CONTEXT_ID           ,"context_id"           ,Tcontext_t        ,_param->_size_context_id      );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_FRONT_END_ID         ,"front_end_id"         ,Tcontext_t        ,_param->_size_front_end_id    );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_OOO_ENGINE_ID        ,"ooo_engine_id"        ,Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_PACKET_ID            ,"packet_id"            ,Tpacket_t         ,_param->_size_packet_id       );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_OPERATION            ,"operation"            ,Toperation_t      ,_param->_size_operation       );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_TYPE                 ,"type"                 ,Ttype_t           ,_param->_size_type            );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE,"store_queue_ptr_write",Tlsq_ptr_t        ,log2(_param->_size_store_queue));
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ,"load_queue_ptr_write" ,Tlsq_ptr_t        ,log2(_param->_size_load_queue ));
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_HAS_IMMEDIAT         ,"has_immediat"         ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_IMMEDIAT             ,"immediat"             ,Tgeneral_data_t   ,_param->_size_general_data    );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_DATA_RA              ,"data_ra"              ,Tgeneral_data_t   ,_param->_size_general_data    );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_DATA_RB              ,"data_rb"              ,Tgeneral_data_t   ,_param->_size_general_data    );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_DATA_RC              ,"data_rc"              ,Tspecial_data_t   ,_param->_size_special_data    );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_WRITE_RD             ,"write_rd"             ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_NUM_REG_RD           ,"num_reg_rd"           ,Tgeneral_address_t,_param->_size_general_register);
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_WRITE_RE             ,"write_re"             ,Tcontrol_t        ,1                             );
       ALLOC1_SIGNAL_OUT(out_READ_UNIT_OUT_NUM_REG_RE           ,"num_reg_re"           ,Tspecial_address_t,_param->_size_special_register);
     }

    // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("gpr_read", OUT, SOUTH, "Read port.", _param->_nb_gpr_read);

       ALLOC1_VALACK_OUT   (out_GPR_READ_VAL,VAL);
       ALLOC1_VALACK_IN    ( in_GPR_READ_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_GPR_READ_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_GPR_READ_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_data    );
       ALLOC1_SIGNAL_IN ( in_GPR_READ_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_GPR_READ_DATA_VAL     ,"data_val"     ,Tcontrol_t        ,1);
     }

    // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("spr_read", OUT, SOUTH, "Read port.", _param->_nb_spr_read);

       ALLOC1_VALACK_OUT   (out_SPR_READ_VAL,VAL);
       ALLOC1_VALACK_IN    ( in_SPR_READ_ACK,ACK);
       ALLOC1_SIGNAL_OUT(out_SPR_READ_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_OUT(out_SPR_READ_NUM_REG      ,"num_reg"      ,Tspecial_address_t,_param->_size_special_data    );
       ALLOC1_SIGNAL_IN ( in_SPR_READ_DATA         ,"data"         ,Tspecial_data_t   ,_param->_size_special_register);
       ALLOC1_SIGNAL_IN ( in_SPR_READ_DATA_VAL     ,"data_val"     ,Tcontrol_t        ,1);
     }

    // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("gpr_write", IN , SOUTH, "Write port.", _param->_nb_gpr_write);

       ALLOC1_VALACK_IN    ( in_GPR_WRITE_VAL,VAL);
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_data    );
       ALLOC1_SIGNAL_IN ( in_GPR_WRITE_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_register);
     }

    // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("spr_write", IN , SOUTH, "Write port.", _param->_nb_spr_write);

       ALLOC1_VALACK_IN    ( in_SPR_WRITE_VAL,VAL);
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_NUM_REG      ,"num_reg"      ,Tspecial_address_t,_param->_size_special_data    );
       ALLOC1_SIGNAL_IN ( in_SPR_WRITE_DATA         ,"data"         ,Tspecial_data_t   ,_param->_size_special_register);
     }

    // ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("bypass_write", IN , NORTH, "Output of write_queue.", _param->_nb_bypass_write);

       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_VAL      ,"gpr_val"      ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_NUM_REG  ,"gpr_num_reg"  ,Tgeneral_address_t,_param->_size_general_data    );
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_GPR_DATA     ,"gpr_data"     ,Tgeneral_data_t   ,_param->_size_general_register);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_VAL      ,"spr_val"      ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_NUM_REG  ,"spr_num_reg"  ,Tspecial_address_t,_param->_size_special_data    );
       ALLOC1_SIGNAL_IN ( in_BYPASS_WRITE_SPR_DATA     ,"spr_data"     ,Tspecial_data_t   ,_param->_size_special_register);
     }

    // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
     {
       ALLOC1_INTERFACE("bypass_memory", IN , NORTH, "Output of write_queue.", _param->_nb_bypass_memory);

       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_VAL          ,"val"          ,Tcontrol_t        ,1);
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_OOO_ENGINE_ID,"ooo_engine_id",Tcontext_t        ,_param->_size_ooo_engine_id   );
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_NUM_REG      ,"num_reg"      ,Tgeneral_address_t,_param->_size_general_data    );
       ALLOC1_SIGNAL_IN ( in_BYPASS_MEMORY_DATA         ,"data"         ,Tgeneral_data_t   ,_param->_size_general_register);
     }

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

     std::string name;

     {
       name = _name+"_read_queue";
       
       _component_read_queue  = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::read_queue::Read_queue (name.c_str()
#ifdef STATISTICS
																		      ,param_statistics
#endif
																		      ,_param->_param_read_queue);
       
       _component->set_component (_component_read_queue->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }
     {
       name = _name+"_reservation_station";
       
       _component_reservation_station  = new morpheo::behavioural::core::multi_execute_loop::execute_loop::multi_read_unit::read_unit::reservation_station::Reservation_station (name.c_str()
#ifdef STATISTICS
																						 ,param_statistics
#endif
																						 ,_param->_param_reservation_station);
       
       _component->set_component (_component_reservation_station->_component
#ifdef POSITION
				  , 50, 50, 10, 10
#endif
				  );
     }

    // ~~~~~[ Instanciation ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    
     {
       name = _name+"_read_queue";
       std::cout << "Instance : " << name << std::endl;
       {
#ifdef POSITION
	 _component->interface_map (name ,"",
				    _name,"");
#endif

	 _component->port_map(name,"in_CLOCK" , _name, "in_CLOCK");
	 _component->port_map(name,"in_NRESET", _name, "in_NRESET");
       }

       // ~~~~~[ Interface "read_queue_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       {
	 std::string dest = _name;
#ifdef POSITION
	 _component->interface_map (name,"read_queue_in",
				    dest,"read_unit_in");
#endif

	 _component->port_map(name, "in_READ_QUEUE_IN_VAL"                  ,dest, "in_READ_UNIT_IN_VAL"                  );
	 _component->port_map(name,"out_READ_QUEUE_IN_ACK"                  ,dest,"out_READ_UNIT_IN_ACK"                  );
	 if (_param->_have_port_context_id)
	 _component->port_map(name, "in_READ_QUEUE_IN_CONTEXT_ID"           ,dest, "in_READ_UNIT_IN_CONTEXT_ID"           );
	 if (_param->_have_port_front_end_id)
	 _component->port_map(name, "in_READ_QUEUE_IN_FRONT_END_ID"         ,dest, "in_READ_UNIT_IN_FRONT_END_ID"         );
	 if (_param->_have_port_ooo_engine_id)
	 _component->port_map(name, "in_READ_QUEUE_IN_OOO_ENGINE_ID"        ,dest, "in_READ_UNIT_IN_OOO_ENGINE_ID"        );
	 if (_param->_have_port_packet_id)
	 _component->port_map(name, "in_READ_QUEUE_IN_ROB_ID"               ,dest, "in_READ_UNIT_IN_PACKET_ID"            );
	 _component->port_map(name, "in_READ_QUEUE_IN_OPERATION"            ,dest, "in_READ_UNIT_IN_OPERATION"            );
	 _component->port_map(name, "in_READ_QUEUE_IN_TYPE"                 ,dest, "in_READ_UNIT_IN_TYPE"                 );
	 _component->port_map(name, "in_READ_QUEUE_IN_STORE_QUEUE_PTR_WRITE",dest, "in_READ_UNIT_IN_STORE_QUEUE_PTR_WRITE");
	 if (_param->_have_port_load_queue_ptr)
	 _component->port_map(name, "in_READ_QUEUE_IN_LOAD_QUEUE_PTR_WRITE" ,dest, "in_READ_UNIT_IN_LOAD_QUEUE_PTR_WRITE" );
	 _component->port_map(name, "in_READ_QUEUE_IN_HAS_IMMEDIAT"         ,dest, "in_READ_UNIT_IN_HAS_IMMEDIAT"         );
	 _component->port_map(name, "in_READ_QUEUE_IN_IMMEDIAT"             ,dest, "in_READ_UNIT_IN_IMMEDIAT"             );
	 _component->port_map(name, "in_READ_QUEUE_IN_READ_RA"              ,dest, "in_READ_UNIT_IN_READ_RA"              );
	 _component->port_map(name, "in_READ_QUEUE_IN_NUM_REG_RA"           ,dest, "in_READ_UNIT_IN_NUM_REG_RA"           );
	 _component->port_map(name, "in_READ_QUEUE_IN_READ_RB"              ,dest, "in_READ_UNIT_IN_READ_RB"              );
	 _component->port_map(name, "in_READ_QUEUE_IN_NUM_REG_RB"           ,dest, "in_READ_UNIT_IN_NUM_REG_RB"           );
	 _component->port_map(name, "in_READ_QUEUE_IN_READ_RC"              ,dest, "in_READ_UNIT_IN_READ_RC"              );
	 _component->port_map(name, "in_READ_QUEUE_IN_NUM_REG_RC"           ,dest, "in_READ_UNIT_IN_NUM_REG_RC"           );
	 _component->port_map(name, "in_READ_QUEUE_IN_WRITE_RD"             ,dest, "in_READ_UNIT_IN_WRITE_RD"             );
	 _component->port_map(name, "in_READ_QUEUE_IN_NUM_REG_RD"           ,dest, "in_READ_UNIT_IN_NUM_REG_RD"           );
	 _component->port_map(name, "in_READ_QUEUE_IN_WRITE_RE"             ,dest, "in_READ_UNIT_IN_WRITE_RE"             );
	 _component->port_map(name, "in_READ_QUEUE_IN_NUM_REG_RE"           ,dest, "in_READ_UNIT_IN_NUM_REG_RE"           );
       }
       // ~~~~~[ Interface "read_queue_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       {
	 std::string dest = _name+"_reservation_station";
	 
#ifdef POSITION
	 _component->interface_map (name,"read_queue_in",
				    dest,"insert");
#endif

	 _component->port_map(name,"out_READ_QUEUE_OUT_VAL"                  ,dest, "in_INSERT_VAL"                  );
	 _component->port_map(name, "in_READ_QUEUE_OUT_ACK"                  ,dest,"out_INSERT_ACK"                  );
	 if (_param->_have_port_context_id)
	 _component->port_map(name,"out_READ_QUEUE_OUT_CONTEXT_ID"           ,dest, "in_INSERT_CONTEXT_ID"           );
	 if (_param->_have_port_front_end_id)
	 _component->port_map(name,"out_READ_QUEUE_OUT_FRONT_END_ID"         ,dest, "in_INSERT_FRONT_END_ID"         );
	 if (_param->_have_port_ooo_engine_id)
	 _component->port_map(name,"out_READ_QUEUE_OUT_OOO_ENGINE_ID"        ,dest, "in_INSERT_OOO_ENGINE_ID"        );
	 if (_param->_have_port_packet_id)
	 _component->port_map(name,"out_READ_QUEUE_OUT_ROB_ID"               ,dest, "in_INSERT_ROB_ID"               );
	 _component->port_map(name,"out_READ_QUEUE_OUT_OPERATION"            ,dest, "in_INSERT_OPERATION"            );
	 _component->port_map(name,"out_READ_QUEUE_OUT_TYPE"                 ,dest, "in_INSERT_TYPE"                 );
	 _component->port_map(name,"out_READ_QUEUE_OUT_STORE_QUEUE_PTR_WRITE",dest, "in_INSERT_STORE_QUEUE_PTR_WRITE");
	 if (_param->_have_port_load_queue_ptr)
	 _component->port_map(name,"out_READ_QUEUE_OUT_LOAD_QUEUE_PTR_WRITE" ,dest, "in_INSERT_LOAD_QUEUE_PTR_WRITE" );
	 _component->port_map(name,"out_READ_QUEUE_OUT_HAS_IMMEDIAT"         ,dest, "in_INSERT_HAS_IMMEDIAT"         );
	 _component->port_map(name,"out_READ_QUEUE_OUT_IMMEDIAT"             ,dest, "in_INSERT_IMMEDIAT"             );
// 	 _component->port_map(name,"out_READ_QUEUE_OUT_READ_RA"              ,dest, "in_INSERT_READ_RA"              );
	 _component->port_map(name,"out_READ_QUEUE_OUT_NUM_REG_RA"           ,dest, "in_INSERT_NUM_REG_RA"           );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RA_VAL"          ,dest, "in_INSERT_DATA_RA_VAL"          );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RA"              ,dest, "in_INSERT_DATA_RA"              );
// 	 _component->port_map(name,"out_READ_QUEUE_OUT_READ_RB"              ,dest, "in_INSERT_READ_RB"              );
	 _component->port_map(name,"out_READ_QUEUE_OUT_NUM_REG_RB"           ,dest, "in_INSERT_NUM_REG_RB"           );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RB_VAL"          ,dest, "in_INSERT_DATA_RB_VAL"          );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RB"              ,dest, "in_INSERT_DATA_RB"              );
// 	 _component->port_map(name,"out_READ_QUEUE_OUT_READ_RC"              ,dest, "in_INSERT_READ_RC"              );
	 _component->port_map(name,"out_READ_QUEUE_OUT_NUM_REG_RC"           ,dest, "in_INSERT_NUM_REG_RC"           );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RC_VAL"          ,dest, "in_INSERT_DATA_RC_VAL"          );
	 _component->port_map(name,"out_READ_QUEUE_OUT_DATA_RC"              ,dest, "in_INSERT_DATA_RC"              );
	 _component->port_map(name,"out_READ_QUEUE_OUT_WRITE_RD"             ,dest, "in_INSERT_WRITE_RD"             );
	 _component->port_map(name,"out_READ_QUEUE_OUT_NUM_REG_RD"           ,dest, "in_INSERT_NUM_REG_RD"           );
	 _component->port_map(name,"out_READ_QUEUE_OUT_WRITE_RE"             ,dest, "in_INSERT_WRITE_RE"             );
	 _component->port_map(name,"out_READ_QUEUE_OUT_NUM_REG_RE"           ,dest, "in_INSERT_NUM_REG_RE"           );
       }
       // ~~~~~[ Interface "gpr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_gpr_read; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"gpr_read_"+toString(i),
				      dest,"gpr_read_"+toString(i));
#endif

	   _component->port_map(name,"out_GPR_READ_"+toString(i)+"_VAL"          ,dest,"out_GPR_READ_"+toString(i)+"_VAL"          );
	   _component->port_map(name, "in_GPR_READ_"+toString(i)+"_ACK"          ,dest, "in_GPR_READ_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_GPR_READ_"+toString(i)+"_OOO_ENGINE_ID",dest,"out_GPR_READ_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name,"out_GPR_READ_"+toString(i)+"_NUM_REG"      ,dest,"out_GPR_READ_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_GPR_READ_"+toString(i)+"_DATA"         ,dest, "in_GPR_READ_"+toString(i)+"_DATA"         );
	   _component->port_map(name, "in_GPR_READ_"+toString(i)+"_DATA_VAL"     ,dest, "in_GPR_READ_"+toString(i)+"_DATA_VAL"     );
	 }

       // ~~~~~[ Interface "spr_read" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_spr_read; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"spr_read_"+toString(i),
				      dest,"spr_read_"+toString(i));
#endif

	   _component->port_map(name,"out_SPR_READ_"+toString(i)+"_VAL"          ,dest,"out_SPR_READ_"+toString(i)+"_VAL"          );
	   _component->port_map(name, "in_SPR_READ_"+toString(i)+"_ACK"          ,dest, "in_SPR_READ_"+toString(i)+"_ACK"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_SPR_READ_"+toString(i)+"_OOO_ENGINE_ID",dest,"out_SPR_READ_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name,"out_SPR_READ_"+toString(i)+"_NUM_REG"      ,dest,"out_SPR_READ_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_SPR_READ_"+toString(i)+"_DATA"         ,dest, "in_SPR_READ_"+toString(i)+"_DATA"         );
	   _component->port_map(name, "in_SPR_READ_"+toString(i)+"_DATA_VAL"     ,dest, "in_SPR_READ_"+toString(i)+"_DATA_VAL"     );
	 }

       // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"gpr_write_"+toString(i),
				      dest,"gpr_write_"+toString(i));
#endif
	   
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_VAL"          ,dest, "in_GPR_WRITE_"+toString(i)+"_VAL"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest, "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_DATA"         ,dest, "in_GPR_WRITE_"+toString(i)+"_DATA"         );
	 }
       // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_spr_write; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"spr_write_"+toString(i),
				      dest,"spr_write_"+toString(i));
#endif
	   
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_VAL"          ,dest, "in_SPR_WRITE_"+toString(i)+"_VAL"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest, "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_DATA"         ,dest, "in_SPR_WRITE_"+toString(i)+"_DATA"         );
	 }
     }

     {
       name = _name+"_reservation_station";
       std::cout << "Instance : " << name << std::endl;
       {
#ifdef POSITION
	 _component->interface_map (name ,"",
				    _name,"");
#endif

	 _component->port_map(name,"in_CLOCK" , _name, "in_CLOCK");
	 _component->port_map(name,"in_NRESET", _name, "in_NRESET");
       }

       // ~~~~~[ Interface "insert" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       {
	 std::string dest = _name+"_read_queue";
	 
#ifdef POSITION
	 _component->interface_map (name,"insert",
				    dest,"read_queue_in");
#endif

	 _component->port_map(name, "in_INSERT_VAL"                  ,dest,"out_READ_QUEUE_OUT_VAL"                  );
	 _component->port_map(name,"out_INSERT_ACK"                  ,dest, "in_READ_QUEUE_OUT_ACK"                  );
	 if (_param->_have_port_context_id)
	 _component->port_map(name, "in_INSERT_CONTEXT_ID"           ,dest,"out_READ_QUEUE_OUT_CONTEXT_ID"           );
	 if (_param->_have_port_front_end_id)
	 _component->port_map(name, "in_INSERT_FRONT_END_ID"         ,dest,"out_READ_QUEUE_OUT_FRONT_END_ID"         );
	 if (_param->_have_port_ooo_engine_id)
	 _component->port_map(name, "in_INSERT_OOO_ENGINE_ID"        ,dest,"out_READ_QUEUE_OUT_OOO_ENGINE_ID"        );
	 if (_param->_have_port_packet_id)
	 _component->port_map(name, "in_INSERT_ROB_ID"               ,dest,"out_READ_QUEUE_OUT_ROB_ID"               );
	 _component->port_map(name, "in_INSERT_OPERATION"            ,dest,"out_READ_QUEUE_OUT_OPERATION"            );
	 _component->port_map(name, "in_INSERT_TYPE"                 ,dest,"out_READ_QUEUE_OUT_TYPE"                 );
	 _component->port_map(name, "in_INSERT_STORE_QUEUE_PTR_WRITE",dest,"out_READ_QUEUE_OUT_STORE_QUEUE_PTR_WRITE");
	 if (_param->_have_port_load_queue_ptr)
	 _component->port_map(name, "in_INSERT_LOAD_QUEUE_PTR_WRITE" ,dest,"out_READ_QUEUE_OUT_LOAD_QUEUE_PTR_WRITE" );
	 _component->port_map(name, "in_INSERT_HAS_IMMEDIAT"         ,dest,"out_READ_QUEUE_OUT_HAS_IMMEDIAT"         );
	 _component->port_map(name, "in_INSERT_IMMEDIAT"             ,dest,"out_READ_QUEUE_OUT_IMMEDIAT"             );
// 	 _component->port_map(name, "in_INSERT_READ_RA"              ,dest,"out_READ_QUEUE_OUT_READ_RA"              );
	 _component->port_map(name, "in_INSERT_NUM_REG_RA"           ,dest,"out_READ_QUEUE_OUT_NUM_REG_RA"           );
	 _component->port_map(name, "in_INSERT_DATA_RA_VAL"          ,dest,"out_READ_QUEUE_OUT_DATA_RA_VAL"          );
	 _component->port_map(name, "in_INSERT_DATA_RA"              ,dest,"out_READ_QUEUE_OUT_DATA_RA"              );
// 	 _component->port_map(name, "in_INSERT_READ_RB"              ,dest,"out_READ_QUEUE_OUT_READ_RB"              );
	 _component->port_map(name, "in_INSERT_NUM_REG_RB"           ,dest,"out_READ_QUEUE_OUT_NUM_REG_RB"           );
	 _component->port_map(name, "in_INSERT_DATA_RB_VAL"          ,dest,"out_READ_QUEUE_OUT_DATA_RB_VAL"          );
	 _component->port_map(name, "in_INSERT_DATA_RB"              ,dest,"out_READ_QUEUE_OUT_DATA_RB"              );
// 	 _component->port_map(name, "in_INSERT_READ_RC"              ,dest,"out_READ_QUEUE_OUT_READ_RC"              );
	 _component->port_map(name, "in_INSERT_NUM_REG_RC"           ,dest,"out_READ_QUEUE_OUT_NUM_REG_RC"           );
	 _component->port_map(name, "in_INSERT_DATA_RC_VAL"          ,dest,"out_READ_QUEUE_OUT_DATA_RC_VAL"          );
	 _component->port_map(name, "in_INSERT_DATA_RC"              ,dest,"out_READ_QUEUE_OUT_DATA_RC"              );
	 _component->port_map(name, "in_INSERT_WRITE_RD"             ,dest,"out_READ_QUEUE_OUT_WRITE_RD"             );
	 _component->port_map(name, "in_INSERT_NUM_REG_RD"           ,dest,"out_READ_QUEUE_OUT_NUM_REG_RD"           );
	 _component->port_map(name, "in_INSERT_WRITE_RE"             ,dest,"out_READ_QUEUE_OUT_WRITE_RE"             );
	 _component->port_map(name, "in_INSERT_NUM_REG_RE"           ,dest,"out_READ_QUEUE_OUT_NUM_REG_RE"           );
       }

       // ~~~~~[ Interface "retire" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_inst_retire; i++)
	 {
	   std::string dest = _name;
	   
#ifdef POSITION
	   _component->interface_map (name,"retire_"+toString(i),
				      dest,"read_unit_out_"+toString(i));
#endif
	   
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_VAL"                  ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_VAL"                  );
	   _component->port_map(name, "in_RETIRE_"+toString(i)+"_ACK"                  ,dest, "in_READ_UNIT_OUT_"+toString(i)+"_ACK"                  );
	   if (_param->_have_port_context_id)
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_CONTEXT_ID"           ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_CONTEXT_ID"           );
	   if (_param->_have_port_front_end_id)
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_FRONT_END_ID"         ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_FRONT_END_ID"         );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_OOO_ENGINE_ID"        ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_OOO_ENGINE_ID"        );
	   if (_param->_have_port_packet_id)
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_ROB_ID"               ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_PACKET_ID"            );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_OPERATION"            ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_OPERATION"            );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_TYPE"                 ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_TYPE"                 );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_STORE_QUEUE_PTR_WRITE",dest,"out_READ_UNIT_OUT_"+toString(i)+"_STORE_QUEUE_PTR_WRITE");
	   if (_param->_have_port_load_queue_ptr)
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_LOAD_QUEUE_PTR_WRITE" );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_HAS_IMMEDIAT"         ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_HAS_IMMEDIAT"         );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_IMMEDIAT"             ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_IMMEDIAT"             );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_DATA_RA"              ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_DATA_RA"              );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_DATA_RB"              ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_DATA_RB"              );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_DATA_RC"              ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_DATA_RC"              );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_WRITE_RD"             ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_WRITE_RD"             );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_NUM_REG_RD"           ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_NUM_REG_RD"           );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_WRITE_RE"             ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_WRITE_RE"             );
	   _component->port_map(name,"out_RETIRE_"+toString(i)+"_NUM_REG_RE"           ,dest,"out_READ_UNIT_OUT_"+toString(i)+"_NUM_REG_RE"           );
	 }

       // ~~~~~[ Interface "gpr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_gpr_write; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"gpr_write_"+toString(i),
				      dest,"gpr_write_"+toString(i));
#endif
	   
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_VAL"          ,dest, "in_GPR_WRITE_"+toString(i)+"_VAL"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_GPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest, "in_GPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_GPR_WRITE_"+toString(i)+"_DATA"         ,dest, "in_GPR_WRITE_"+toString(i)+"_DATA"         );
	 }
       // ~~~~~[ Interface "spr_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_spr_write; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"spr_write_"+toString(i),
				      dest,"spr_write_"+toString(i));
#endif
	   
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_VAL"          ,dest, "in_SPR_WRITE_"+toString(i)+"_VAL"          );
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_SPR_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      ,dest, "in_SPR_WRITE_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_SPR_WRITE_"+toString(i)+"_DATA"         ,dest, "in_SPR_WRITE_"+toString(i)+"_DATA"         );
	 }
       // ~~~~~[ Interface "bypass_write" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_bypass_write; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"bypass_write_"+toString(i),
				      dest,"bypass_write_"+toString(i));
#endif
	   
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_BYPASS_WRITE_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_GPR_VAL"      ,dest, "in_BYPASS_WRITE_"+toString(i)+"_GPR_VAL"      );
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_GPR_NUM_REG"  ,dest, "in_BYPASS_WRITE_"+toString(i)+"_GPR_NUM_REG"  );
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_GPR_DATA"     ,dest, "in_BYPASS_WRITE_"+toString(i)+"_GPR_DATA"     );
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_SPR_VAL"      ,dest, "in_BYPASS_WRITE_"+toString(i)+"_SPR_VAL"      );
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_SPR_NUM_REG"  ,dest, "in_BYPASS_WRITE_"+toString(i)+"_SPR_NUM_REG"  );
	   _component->port_map(name, "in_BYPASS_WRITE_"+toString(i)+"_SPR_DATA"     ,dest, "in_BYPASS_WRITE_"+toString(i)+"_SPR_DATA"     );
	 }
       // ~~~~~[ Interface "bypass_memory" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       for (uint32_t i=0; i<_param->_nb_bypass_memory; i++)
	 {
	   std::string dest = _name;
#ifdef POSITION
	   _component->interface_map (name,"bypass_memory_"+toString(i),
				      dest,"bypass_memory_"+toString(i));
#endif
	   
	   if (_param->_have_port_ooo_engine_id)
	   _component->port_map(name, "in_BYPASS_MEMORY_"+toString(i)+"_OOO_ENGINE_ID",dest, "in_BYPASS_MEMORY_"+toString(i)+"_OOO_ENGINE_ID");
	   _component->port_map(name, "in_BYPASS_MEMORY_"+toString(i)+"_VAL"          ,dest, "in_BYPASS_MEMORY_"+toString(i)+"_VAL"          );
	   _component->port_map(name, "in_BYPASS_MEMORY_"+toString(i)+"_NUM_REG"      ,dest, "in_BYPASS_MEMORY_"+toString(i)+"_NUM_REG"      );
	   _component->port_map(name, "in_BYPASS_MEMORY_"+toString(i)+"_DATA"         ,dest, "in_BYPASS_MEMORY_"+toString(i)+"_DATA"         );
	 }       
     }
     

#ifdef POSITION
    _component->generate_file();
#endif

    log_printf(FUNC,Read_unit,FUNCTION,"End");
  };

}; // end namespace read_unit
}; // end namespace multi_read_unit
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
