#ifndef morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Read_unit_to_Execution_unit_h
#define morpheo_behavioural_core_multi_execute_loop_execute_loop_network_read_unit_to_execution_unit_Read_unit_to_Execution_unit_h

/*
 * $Id: Read_unit_to_Execution_unit.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include <list>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"
#include "Behavioural/include/Identification.h"

#include "Behavioural/Core/Multi_Execute_loop/Execute_loop/Network/Read_unit_to_Execution_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_execute_loop {
namespace execute_loop {
namespace network {
namespace read_unit_to_execution_unit {


  class Read_unit_to_Execution_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "read_unit_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_IN (Tcontrol_t        )   **  in_READ_UNIT_OUT_VAL                  ;
  public    : SC_OUT(Tcontrol_t        )   ** out_READ_UNIT_OUT_ACK                  ;
  public    : SC_IN (Tcontext_t        )   **  in_READ_UNIT_OUT_CONTEXT_ID           ;
  public    : SC_IN (Tcontext_t        )   **  in_READ_UNIT_OUT_FRONT_END_ID         ;
  public    : SC_IN (Tcontext_t        )   **  in_READ_UNIT_OUT_OOO_ENGINE_ID        ;
  public    : SC_IN (Tpacket_t         )   **  in_READ_UNIT_OUT_PACKET_ID            ;
  public    : SC_IN (Toperation_t      )   **  in_READ_UNIT_OUT_OPERATION            ;
  public    : SC_IN (Ttype_t           )   **  in_READ_UNIT_OUT_TYPE                 ;
  public    : SC_IN (Tlsq_ptr_t        )   **  in_READ_UNIT_OUT_STORE_QUEUE_PTR_WRITE;
  public    : SC_IN (Tlsq_ptr_t        )   **  in_READ_UNIT_OUT_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_IN (Tcontrol_t        )   **  in_READ_UNIT_OUT_HAS_IMMEDIAT         ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_READ_UNIT_OUT_IMMEDIAT             ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_READ_UNIT_OUT_DATA_RA              ;
  public    : SC_IN (Tgeneral_data_t   )   **  in_READ_UNIT_OUT_DATA_RB              ;
  public    : SC_IN (Tspecial_data_t   )   **  in_READ_UNIT_OUT_DATA_RC              ;
  public    : SC_IN (Tcontrol_t        )   **  in_READ_UNIT_OUT_WRITE_RD             ;
  public    : SC_IN (Tgeneral_address_t)   **  in_READ_UNIT_OUT_NUM_REG_RD           ;
  public    : SC_IN (Tcontrol_t        )   **  in_READ_UNIT_OUT_WRITE_RE             ;
  public    : SC_IN (Tspecial_address_t)   **  in_READ_UNIT_OUT_NUM_REG_RE           ;

    // ~~~~~[ Interface "execute_unit_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_UNIT_IN_VAL                  ;
  public    : SC_IN (Tcontrol_t        )   **  in_EXECUTE_UNIT_IN_ACK                  ;
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_UNIT_IN_CONTEXT_ID           ;
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_UNIT_IN_FRONT_END_ID         ;
  public    : SC_OUT(Tcontext_t        )   ** out_EXECUTE_UNIT_IN_OOO_ENGINE_ID        ;
  public    : SC_OUT(Tpacket_t         )   ** out_EXECUTE_UNIT_IN_PACKET_ID            ;
  public    : SC_OUT(Toperation_t      )   ** out_EXECUTE_UNIT_IN_OPERATION            ;
  public    : SC_OUT(Ttype_t           )   ** out_EXECUTE_UNIT_IN_TYPE                 ;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_EXECUTE_UNIT_IN_STORE_QUEUE_PTR_WRITE;
  public    : SC_OUT(Tlsq_ptr_t        )   ** out_EXECUTE_UNIT_IN_LOAD_QUEUE_PTR_WRITE ;
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_UNIT_IN_HAS_IMMEDIAT         ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_EXECUTE_UNIT_IN_IMMEDIAT             ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_EXECUTE_UNIT_IN_DATA_RA              ;
  public    : SC_OUT(Tgeneral_data_t   )   ** out_EXECUTE_UNIT_IN_DATA_RB              ;
  public    : SC_OUT(Tspecial_data_t   )   ** out_EXECUTE_UNIT_IN_DATA_RC              ;
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_UNIT_IN_WRITE_RD             ;
  public    : SC_OUT(Tgeneral_address_t)   ** out_EXECUTE_UNIT_IN_NUM_REG_RD           ;
  public    : SC_OUT(Tcontrol_t        )   ** out_EXECUTE_UNIT_IN_WRITE_RE             ;
  public    : SC_OUT(Tspecial_address_t)   ** out_EXECUTE_UNIT_IN_NUM_REG_RE           ;

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
  private   : std::list<uint32_t> *** _destination; // [nb_read_unit][nb_thread][nb_type];
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Read_unit_to_Execution_unit);
#endif
  public  :          Read_unit_to_Execution_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Read_unit_to_Execution_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
  public  : void        transition                (void);
  public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace read_unit_to_execution_unit
}; // end namespace network
}; // end namespace execute_loop
}; // end namespace multi_execute_loop
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
