/*
 * $Id: Parameters.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Decod_unit/Decod/include/Parameters.h"
#include "Common/include/Max.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace decod_unit {
namespace decod {


#undef  FUNCTION
#define FUNCTION "Decod::Parameters"
  Parameters::Parameters (uint32_t            nb_context                   ,
			  uint32_t          * nb_inst_fetch                ,
			  uint32_t            nb_inst_decod                ,
			  uint32_t            nb_branch_speculated         ,
			  uint32_t            size_branch_update_prediction,
			  uint32_t            nb_context_select            ,
			  uint32_t            size_general_data            ,
			  Tpriority_t         priority                     ,
			  Tload_balancing_t   load_balancing               ,
			  bool             ** instruction_implemeted       ,
			  morpheo::behavioural::custom::custom_information_t (*get_custom_information) (uint32_t))
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");

    _nb_context                    = nb_context                   ;
    _nb_inst_fetch                 = nb_inst_fetch                ;
    _nb_inst_decod                 = nb_inst_decod                ;
    _nb_branch_speculated          = nb_branch_speculated         ;
    _nb_context_select             = nb_context_select            ;
    _size_branch_update_prediction = size_branch_update_prediction;
    _size_general_data             = size_general_data            ;
    _priority                      = priority                     ;
    _load_balancing                = load_balancing               ;
    _instruction_implemeted        = instruction_implemeted       ;

    if (get_custom_information == NULL)
      _get_custom_information = &(morpheo::behavioural::custom::default_get_custom_information);
    else
      _get_custom_information = get_custom_information;

    
    _max_nb_inst_fetch                     = max<uint32_t>(nb_inst_fetch,nb_context);

    _size_context_id                       = log2(nb_context          );
    _size_depth                            = log2(nb_branch_speculated);
    _size_inst_ifetch_ptr                  = log2(_max_nb_inst_fetch  );

    _have_port_context_id                  = _size_context_id > 0;
    _have_port_depth                       = _size_depth      > 0;
    _have_port_branch_update_prediction_id = _size_branch_update_prediction > 0;
    _have_port_inst_ifetch_ptr             = _size_inst_ifetch_ptr > 0;
    
    test();
    log_printf(FUNC,Decod,FUNCTION,"End");
  };
  
// #undef  FUNCTION
// #define FUNCTION "Decod::Parameters (copy)"
//   Parameters::Parameters (Parameters & param)
//   {
//     log_printf(FUNC,Decod,FUNCTION,"Begin");
//     test();
//     log_printf(FUNC,Decod,FUNCTION,"End");
//   };

#undef  FUNCTION
#define FUNCTION "Decod::~Parameters"
  Parameters::~Parameters () 
  {
    log_printf(FUNC,Decod,FUNCTION,"Begin");
    log_printf(FUNC,Decod,FUNCTION,"End");
  };

}; // end namespace decod
}; // end namespace decod_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
