#ifdef SYSTEMC
/*
 * $Id: Address_management_genMoore.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Ifetch_unit/Address_management/include/Address_management.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace ifetch_unit {
namespace address_management {


#undef  FUNCTION
#define FUNCTION "Address_management::genMoore"
  void Address_management::genMoore (void)
  {
    log_printf(FUNC,Address_management,FUNCTION,"Begin");

    // =========================================
    // ===== ADDRESS ===========================
    // =========================================

    internal_ADDRESS_VAL = reg_PC_CURRENT_VAL;

    PORT_WRITE(out_ADDRESS_VAL                        ,internal_ADDRESS_VAL                      );
    PORT_WRITE(out_ADDRESS_INSTRUCTION_ADDRESS        ,reg_PC_CURRENT                            );
    if (_param->_have_port_instruction_ptr)
    PORT_WRITE(out_ADDRESS_INST_IFETCH_PTR            ,reg_PC_CURRENT_INST_IFETCH_PTR            );
    PORT_WRITE(out_ADDRESS_BRANCH_STATE               ,reg_PC_CURRENT_BRANCH_STATE               );
    if (_param->_have_port_branch_update_prediction_id)
    PORT_WRITE(out_ADDRESS_BRANCH_UPDATE_PREDICTION_ID,reg_PC_CURRENT_BRANCH_UPDATE_PREDICTION_ID);

    for (uint32_t i=0; i<_param->_nb_instruction; i++)
      PORT_WRITE(out_ADDRESS_INSTRUCTION_ENABLE [i], reg_PC_CURRENT_INSTRUCTION_ENABLE[i]);

    // =========================================
    // ===== PREDICT ===========================
    // =========================================

    internal_PREDICT_VAL = reg_PC_PREVIOUS_VAL and not reg_PC_NEXT_VAL;

    PORT_WRITE(out_PREDICT_VAL                  ,internal_PREDICT_VAL);
    PORT_WRITE(out_PREDICT_PC_PREVIOUS          ,reg_PC_PREVIOUS          );
    PORT_WRITE(out_PREDICT_PC_CURRENT           ,reg_PC_CURRENT           );
    PORT_WRITE(out_PREDICT_PC_CURRENT_IS_DS_TAKE,reg_PC_CURRENT_IS_DS_TAKE);
    


    log_printf(FUNC,Address_management,FUNCTION,"End");
  };

}; // end namespace address_management
}; // end namespace ifetch_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
