#ifdef SYSTEMC
/*
 * $Id: Branch_Target_Buffer_Glue_genMealy_decod.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/Branch_Target_Buffer_Glue/include/Branch_Target_Buffer_Glue.h"

namespace morpheo {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {
namespace branch_target_buffer_glue {

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer_Glue::genMealy_decod"
  void Branch_Target_Buffer_Glue::genMealy_decod (void)
  {
    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"Begin");

    for (uint32_t i=0; i<_param->_nb_inst_decod; i++)
      {
	Tcontrol_t val          = PORT_READ(in_DECOD_VAL          [i]);
	Tcontrol_t register_ack = PORT_READ(in_DECOD_REGISTER_ACK [i]);
	Tcontrol_t victim_ack   = (_param->_have_port_victim)?PORT_READ(in_DECOD_VICTIM_ACK [i]):true;
	
	PORT_WRITE(out_DECOD_ACK            [i],         register_ack and victim_ack);
	PORT_WRITE(out_DECOD_REGISTER_VAL   [i], val and                  victim_ack);

	if (_param->_have_port_victim)
	  {
	PORT_WRITE(out_DECOD_VICTIM_VAL     [i], val and register_ack );
	if (not _param->_is_full_associative)
	PORT_WRITE(out_DECOD_VICTIM_ADDRESS [i], (PORT_READ(in_DECOD_ADDRESS_SRC [i]) >> _param->_shift_bank)&_param->_mask_bank);
	  }
      }

    log_printf(FUNC,Branch_Target_Buffer_Glue,FUNCTION,"End");
  };

}; // end namespace branch_target_buffer_glue
}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
