/*
 * $Id: Parameters_print.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Branch_Target_Buffer/include/Parameters.h"
#include "Behavioural/include/XML.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_front_end {
namespace front_end {
namespace prediction_unit {
namespace branch_target_buffer {


#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer::print"
  std::string Parameters::print (uint32_t depth)
  {
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"Begin");

    XML xml ("branch_target_buffer");

    xml.balise_open("branch_target_buffer");
    xml.singleton_begin("nb_context     "); xml.attribut("value",toString(_nb_context     )); xml.singleton_end();
    xml.singleton_begin("size_buffer    "); xml.attribut("value",toString(_size_buffer    )); xml.singleton_end();
    xml.singleton_begin("associativity  "); xml.attribut("value",toString(_associativity  )); xml.singleton_end();
    xml.singleton_begin("size_address   "); xml.attribut("value",toString(_size_address   )); xml.singleton_end();
    xml.singleton_begin("size_counter   "); xml.attribut("value",toString(_size_counter   )); xml.singleton_end();
    xml.singleton_begin("nb_inst_predict"); xml.attribut("value",toString(_nb_inst_predict)); xml.singleton_end();
    xml.singleton_begin("nb_inst_decod  "); xml.attribut("value",toString(_nb_inst_decod  )); xml.singleton_end();
    xml.singleton_begin("nb_inst_update "); xml.attribut("value",toString(_nb_inst_update )); xml.singleton_end();
    xml.singleton_begin("victim_scheme  "); xml.attribut("value",toString(_victim_scheme  )); xml.singleton_end();
    for (uint32_t i=0;i<_nb_context; i++)
      {
	xml. balise_open_begin("component");
	xml.  attribut("type","context");
	xml.  attribut("id"  ,toString(i));
	xml. balise_open_end();
	xml.  singleton_begin("nb_instruction "); xml.attribut("value",toString(_nb_instruction [i])); xml.singleton_end();
	xml. balise_close();
      }
    xml.balise_close();

    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"End");
    
    return xml.get_body(depth);
  };

#undef  FUNCTION
#define FUNCTION "Branch_Target_Buffer::operator<<"
  std::ostream& operator<< (std::ostream& output_stream ,
			    morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::branch_target_buffer::Parameters & x)
  {
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"Begin");

    output_stream << x.print(0);
    
    log_printf(FUNC,Branch_Target_Buffer,FUNCTION,"End");

    return output_stream;
  };

}; // end namespace branch_target_buffer
}; // end namespace prediction_unit
}; // end namespace front_end
}; // end namespace multi_front_end
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
