/*
 * $Id: main.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_Front_end/Front_end/Prediction_unit/Update_Prediction_Table/SelfTest/include/test.h"

#define NB_PARAMS 7

void usage (int argc, char * argv[])
{
  err (_("<Usage> %s name_instance list_params.\n"),argv[0]);
  err (_("list_params is :\n"));
  err (_(" * nb_context                           (uint32_t)\n"));
  err (_(" * size_queue              [nb_context] (uint32_t)\n"));
  err (_(" * size_address                         (uint32_t)\n"));
  err (_(" * nb_inst_predict                      (uint32_t)\n"));
  err (_(" * nb_inst_decod                        (uint32_t)\n"));
  err (_(" * nb_inst_branch_complete              (uint32_t)\n"));
  err (_(" * nb_inst_update                       (uint32_t)\n"));
  err (_(" * size_history                         (uint32_t)\n"));
  err (_(" * size_ras_index          [nb_context] (uint32_t)\n"));

  exit (1);
}

#ifndef SYSTEMC
int main    (int argc, char * argv[])
#else
int sc_main (int argc, char * argv[])
#endif
{
  if (argc <= static_cast<int>(2+NB_PARAMS))
    usage (argc, argv);

  uint32_t x = 1;

  string name = argv[x++];

  uint32_t   _nb_context              = fromString<uint32_t>(argv[x++]);

  if (argc != static_cast<int>(2+NB_PARAMS+2*_nb_context))
    usage (argc, argv);

  uint32_t * _size_queue              = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _size_queue [i] = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_address            = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_predict         = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_decod           = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_branch_complete = fromString<uint32_t>(argv[x++]);
  uint32_t   _nb_inst_update          = fromString<uint32_t>(argv[x++]);
  uint32_t   _size_history            = fromString<uint32_t>(argv[x++]);
  uint32_t * _size_ras_index          = new uint32_t [_nb_context];
  for (uint32_t i=0; i<_nb_context; i++)
    _size_ras_index [i] = fromString<uint32_t>(argv[x++]);

  int _return = EXIT_SUCCESS;
  try 
    {
      morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters * param = new morpheo::behavioural::core::multi_front_end::front_end::prediction_unit::update_prediction_table::Parameters
	(_nb_context             ,
	 _size_queue             ,
	 _size_address           ,
	 _nb_inst_predict        ,
	 _nb_inst_decod          ,
	 _nb_inst_branch_complete,
	 _nb_inst_update         ,
	 _size_history           ,
	 _size_ras_index         );
      
      msg(_("%s"),param->print(1).c_str());
      
      test (name,param);
    }
  catch (morpheo::ErrorMorpheo & error)
    {
      msg (_("<%s> :\n%s"),name.c_str(), error.what ());
      _return = EXIT_FAILURE;
    }
  catch (...)
    {
      err (_("<%s> : This test must generate a error.\n"),name.c_str());
      _return = EXIT_FAILURE;
    }


  delete [] _size_ras_index;
  delete [] _size_queue;

  return (_return);
}
