#ifndef morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_dependency_checking_unit_Dependency_checking_unit_h
#define morpheo_behavioural_core_multi_ooo_engine_ooo_engine_rename_unit_register_translation_unit_dependency_checking_unit_Dependency_checking_unit_h

/*
 * $Id: Dependency_checking_unit.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#ifdef SYSTEMC
#include "systemc.h"
#endif

#include <iostream>
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#include "Behavioural/include/Types.h"

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Register_translation_unit/Dependency_checking_unit/include/Parameters.h"
#ifdef STATISTICS
#include "Behavioural/include/Stat.h"
#endif
#include "Behavioural/include/Component.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"

namespace morpheo {
namespace behavioural {

namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace register_translation_unit {
namespace dependency_checking_unit {


  class Dependency_checking_unit 
#if SYSTEMC
    : public sc_module
#endif
  {
    // -----[ fields ]----------------------------------------------------
    // Parameters
  protected : const std::string  _name;
  protected : const Parameters * _param;
  private   : const Tusage_t     _usage;

#ifdef STATISTICS
  public    : Stat                           * _stat;
#endif

  public    : Component                      * _component;
  private   : Interfaces                     * _interfaces;

#ifdef SYSTEMC
    // ~~~~~[ Interface ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    // Interface
  public    : SC_CLOCK                      *  in_CLOCK        ;
  public    : SC_IN (Tcontrol_t)            *  in_NRESET       ;

    // ~~~~~[ Interface "rename_in" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_VAL                ;//[nb_inst_insert]
//   public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_IN_ACK                ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_RENAME_IN_FRONT_END_ID       ;//[nb_inst_insert]
  public    : SC_IN (Tcontext_t        )   **  in_RENAME_IN_CONTEXT_ID         ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_READ_RA            ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RA_LOG     ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RA_PHY     ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_READ_RB            ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RB_LOG     ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RB_PHY     ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_READ_RC            ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_IN_NUM_REG_RC_LOG     ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_IN_NUM_REG_RC_PHY     ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_WRITE_RD           ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RD_LOG     ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RD_PHY_OLD ;//[nb_inst_insert]
  public    : SC_IN (Tgeneral_address_t)   **  in_RENAME_IN_NUM_REG_RD_PHY_NEW ;//[nb_inst_insert]
  public    : SC_IN (Tcontrol_t        )   **  in_RENAME_IN_WRITE_RE           ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_IN_NUM_REG_RE_LOG     ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_IN_NUM_REG_RE_PHY_OLD ;//[nb_inst_insert]
  public    : SC_IN (Tspecial_address_t)   **  in_RENAME_IN_NUM_REG_RE_PHY_NEW ;//[nb_inst_insert]

    // ~~~~~[ Interface "rename_out" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
//   public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_VAL               ;//[nb_inst_insert]
//   public    : SC_IN (Tcontrol_t        )   **  in_RENAME_OUT_ACK               ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_RENAME_OUT_FRONT_END_ID      ;//[nb_inst_insert]
  public    : SC_OUT(Tcontext_t        )   ** out_RENAME_OUT_CONTEXT_ID        ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RA           ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RA_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RA_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RB           ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RB_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RB_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_READ_RC           ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RC_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RC_PHY    ;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_WRITE_RD          ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RD_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RD_PHY_OLD;//[nb_inst_insert]
  public    : SC_OUT(Tgeneral_address_t)   ** out_RENAME_OUT_NUM_REG_RD_PHY_NEW;//[nb_inst_insert]
  public    : SC_OUT(Tcontrol_t        )   ** out_RENAME_OUT_WRITE_RE          ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RE_LOG    ;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RE_PHY_OLD;//[nb_inst_insert]
  public    : SC_OUT(Tspecial_address_t)   ** out_RENAME_OUT_NUM_REG_RE_PHY_NEW;//[nb_inst_insert]

    // ~~~~~[ Component ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Register ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~    

    // ~~~~~[ Internal ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
#endif

    // -----[ Methods ]---------------------------------------------------

#ifdef SYSTEMC
    SC_HAS_PROCESS (Dependency_checking_unit);
#endif
  public  :          Dependency_checking_unit              
  (
#ifdef SYSTEMC
   sc_module_name                                name,
#else					       
   std::string                                   name,
#endif					       
#ifdef STATISTICS
   morpheo::behavioural::Parameters_Statistics * param_statistics,
#endif
   Parameters                                  * param,
   morpheo::behavioural::Tusage_t                usage=USE_ALL
   );
  public  :          ~Dependency_checking_unit             (void);
					       
  private : void        allocation                (
#ifdef STATISTICS
						   morpheo::behavioural::Parameters_Statistics * param_statistics
#else
						   void
#endif
						   );
  private : void        deallocation              (void);
					       
#ifdef SYSTEMC				       
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  public  : void        transition                (void);
#endif
  public  : void        genMealy                  (void);
#endif					       

#if VHDL				       
  public  : void        vhdl                      (void);
  private : void        vhdl_declaration          (Vhdl * & vhdl);
  private : void        vhdl_body                 (Vhdl * & vhdl);
#endif					       

#ifdef STATISTICS
  public  : void        statistics_declaration    (morpheo::behavioural::Parameters_Statistics * param_statistics);
#endif
#if defined(STATISTICS) or defined(VHDL_TESTBENCH)
  private : void        end_cycle                 (void);
#endif
  };

}; // end namespace dependency_checking_unit
}; // end namespace register_translation_unit
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              

#endif
