#ifdef SYSTEMC
/*
 * $Id: Rename_select_genMealy.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Core/Multi_OOO_Engine/OOO_Engine/Rename_unit/Rename_select/include/Rename_select.h"

namespace morpheo                    {
namespace behavioural {
namespace core {
namespace multi_ooo_engine {
namespace ooo_engine {
namespace rename_unit {
namespace rename_select {


#undef  FUNCTION
#define FUNCTION "Rename_select::genMealy"
  void Rename_select::genMealy (void)
  {
    log_printf(FUNC,Rename_select,FUNCTION,"Begin");

    Tcontrol_t ack [_param->_nb_front_end][_param->_max_nb_inst_decod];
    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	ack [i][j] = false;
    
    std::list<select_t>::iterator it=select.begin();

    for (uint32_t i=0; i<_param->_nb_inst_rename; i++)
      {
	Tcontrol_t val = false;

	while ((it != select.end()) and (val == false))
	  {
	    Tcontext_t x = it->_front_end ;
	    uint32_t   y = it->_inst_decod;

	    // Test if this instruction is valid
	    if (PORT_READ(in_RENAME_IN_VAL[x][y]) == 1)
	      {
		// Find !!!
		val        = true;
		ack [x][y] = PORT_READ(in_RENAME_OUT_ACK [i]);

		if (_param->_have_port_front_end_id)
		PORT_WRITE(out_RENAME_OUT_FRONT_END_ID [i],PORT_READ(in_RENAME_IN_FRONT_END_ID  [x][y]));
		if (_param->_have_port_context_id)
		PORT_WRITE(out_RENAME_OUT_CONTEXT_ID   [i],PORT_READ(in_RENAME_IN_CONTEXT_ID    [x][y]));
		if (_param->_have_port_depth)
		PORT_WRITE(out_RENAME_OUT_DEPTH        [i],PORT_READ(in_RENAME_IN_DEPTH         [x][y]));
		PORT_WRITE(out_RENAME_OUT_TYPE         [i],PORT_READ(in_RENAME_IN_TYPE          [x][y]));
		PORT_WRITE(out_RENAME_OUT_OPERATION    [i],PORT_READ(in_RENAME_IN_OPERATION     [x][y]));
		PORT_WRITE(out_RENAME_OUT_ADDRESS      [i],PORT_READ(in_RENAME_IN_ADDRESS       [x][y]));
		PORT_WRITE(out_RENAME_OUT_HAS_IMMEDIAT [i],PORT_READ(in_RENAME_IN_HAS_IMMEDIAT  [x][y]));
		PORT_WRITE(out_RENAME_OUT_IMMEDIAT     [i],PORT_READ(in_RENAME_IN_IMMEDIAT      [x][y]));
		PORT_WRITE(out_RENAME_OUT_READ_RA      [i],PORT_READ(in_RENAME_IN_READ_RA       [x][y]));
		PORT_WRITE(out_RENAME_OUT_NUM_REG_RA   [i],PORT_READ(in_RENAME_IN_NUM_REG_RA    [x][y]));
		PORT_WRITE(out_RENAME_OUT_READ_RB      [i],PORT_READ(in_RENAME_IN_READ_RB       [x][y]));
		PORT_WRITE(out_RENAME_OUT_NUM_REG_RB   [i],PORT_READ(in_RENAME_IN_NUM_REG_RB    [x][y]));
		PORT_WRITE(out_RENAME_OUT_READ_RC      [i],PORT_READ(in_RENAME_IN_READ_RC       [x][y]));
		PORT_WRITE(out_RENAME_OUT_NUM_REG_RC   [i],PORT_READ(in_RENAME_IN_NUM_REG_RC    [x][y]));
		PORT_WRITE(out_RENAME_OUT_WRITE_RD     [i],PORT_READ(in_RENAME_IN_WRITE_RD      [x][y]));
		PORT_WRITE(out_RENAME_OUT_NUM_REG_RD   [i],PORT_READ(in_RENAME_IN_NUM_REG_RD    [x][y]));
		PORT_WRITE(out_RENAME_OUT_WRITE_RE     [i],PORT_READ(in_RENAME_IN_WRITE_RE      [x][y]));
		PORT_WRITE(out_RENAME_OUT_NUM_REG_RE   [i],PORT_READ(in_RENAME_IN_NUM_REG_RE    [x][y]));
		PORT_WRITE(out_RENAME_OUT_EXCEPTION_USE[i],PORT_READ(in_RENAME_IN_EXCEPTION_USE [x][y]));
	      }

	    it ++;
	  }

	PORT_WRITE(out_RENAME_OUT_VAL [i], val);
      }

    for (uint32_t i=0; i<_param->_nb_front_end; i++)
      for (uint32_t j=0; j<_param->_nb_inst_decod[i]; j++)
	PORT_WRITE(out_RENAME_IN_ACK [i][j], ack [i][j]);

    log_printf(FUNC,Rename_select,FUNCTION,"End");
  };

}; // end namespace rename_select
}; // end namespace rename_unit
}; // end namespace ooo_engine
}; // end namespace multi_ooo_engine
}; // end namespace core

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
