/*
 * $Id: Parameters.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Parameters.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace shifter {


  Parameters::Parameters  (uint32_t    size_data           ,
			   uint32_t    nb_port             ,
			   uint32_t    shift_value         ,
			   rotate_t    rotate              ,
			   direction_t direction           ,
			   carry_t     carry               ,
			   bool        type_completion_bool):
    _size_data                     (size_data     ),
    _nb_port                       (nb_port       ),
    _shift_value                   (shift_value   ),
    _rotate                        (rotate        ),
    _direction                     (direction     ),
    _carry                         (carry         ),
    _size_data_completion          ((carry != external_completion)?0:((_shift_value==0)?size_data:_shift_value)),
    _type_completion_bool          (type_completion_bool),

    _internal_direction            ((direction == internal_right_shift)?_right :_left      ),
    _internal_type                 ((rotate    == internal_rotate     )?_rotate:_shift     ),
    _internal_carry                ((carry     == internal_logic      )?_logic :_arithmetic),

    _have_shift_logic_left         ((rotate != internal_rotate)         &&
				    (((carry     == external_carry     ) ||
				      (carry     == external_completion) ||
				      (carry     == internal_logic     )) && 
				    ((direction == external_direction ) ||
				     (direction == internal_left_shift)))),
    _have_shift_logic_right        ((rotate != internal_rotate)         &&
				    (((carry     == external_carry     ) ||
				      (carry     == external_completion) ||
				      (carry     == internal_logic     )) && 
				    ((direction == external_direction ) ||
				     (direction == internal_right_shift)))),
    _have_shift_logic              (_have_shift_logic_left || _have_shift_logic_right),

    _have_shift_arithmetic_left    ((rotate != internal_rotate)         &&
				    (((carry    == external_carry     ) ||
				      (carry    == internal_arithmetic )) && 
				    ((direction == external_direction ) ||
				     (direction == internal_left_shift)))),
    _have_shift_arithmetic_right   ((rotate != internal_rotate)         &&
				    (((carry     == external_carry     ) ||
				      (carry     == internal_arithmetic     )) && 
				     ((direction == external_direction ) ||
				      (direction == internal_right_shift)))),
    _have_shift_arithmetic         (_have_shift_arithmetic_left || _have_shift_arithmetic_right),

    _have_shift                    (_have_shift_logic || _have_shift_arithmetic),

    _have_rotate_left              ((rotate != without_rotate)         &&
				    ((direction == external_direction ) ||
				     (direction == internal_left_shift))),
    _have_rotate_right             ((rotate != without_rotate)         &&
				    ((direction == external_direction ) || 
				     (direction == internal_right_shift))),
    _have_rotate                   ( _have_rotate_left || _have_rotate_right),

    _have_direction_left           (_have_shift_logic_left       ||
				    _have_shift_arithmetic_left  ||
				    _have_rotate_left            ),
    _have_direction_right          (_have_shift_logic_right      ||
				    _have_shift_arithmetic_right ||
				    _have_rotate_right           )
  {
    test();
  };
  
  Parameters::Parameters (Parameters & param):
    _size_data                   (param._size_data                   ),
    _nb_port                     (param._nb_port                     ),
    _shift_value                 (param._shift_value                 ),
    _rotate                      (param._rotate                      ),
    _direction                   (param._direction                   ),
    _carry                       (param._carry                       ),
    _size_data_completion        (param._size_data_completion        ),
    _type_completion_bool        (param._type_completion_bool        ),

    _internal_direction          (param._internal_direction          ),
    _internal_type               (param._internal_type               ),
    _internal_carry              (param._internal_carry              ),
    
    _have_shift_logic_left       (param._have_shift_logic_left       ),
    _have_shift_logic_right      (param._have_shift_logic_right      ),
    _have_shift_logic            (param._have_shift_logic            ),
    _have_shift_arithmetic_left  (param._have_shift_arithmetic_left  ),
    _have_shift_arithmetic_right (param._have_shift_arithmetic_right ),
    _have_shift_arithmetic       (param._have_shift_arithmetic       ),
    _have_shift                  (param._have_shift                  ),
    _have_rotate_left            (param._have_rotate_left            ),
    _have_rotate_right           (param._have_rotate_right           ),
    _have_rotate                 (param._have_rotate                 ),

    _have_direction_left         (param._have_direction_left         ),
    _have_direction_right        (param._have_direction_right        )

  {
    test();
  };

  Parameters::~Parameters () 
  { };

}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
