#ifdef SYSTEMC
/*
 * $Id: Shifter_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Shifter/include/Shifter.h"

namespace morpheo                    {
namespace behavioural {
namespace generic {
namespace shifter {


  void Shifter::allocation (void)
  {
    _component   = new Component ();

    Entity * entity = _component->set_entity (_name       
					     ,"Shifter"   
#ifdef POSITION
					     ,COMBINATORY 
#endif
					     );
    
    _interfaces = entity->set_interfaces();

#if (defined(STATISTICS) || defined (VHDL_TESTBENCH))
    {
      Interface_fifo * interface = _interfaces->set_interface(""
#ifdef POSITION
							      , IN  
							      , SOUTH
							      , "Generalist interface"
#endif
							      );
      
       in_CLOCK        = interface->set_signal_clk              ("clock" ,1, CLOCK_VHDL_NO);
       in_NRESET       = interface->set_signal_in <Tcontrol_t>  ("nreset",1, RESET_VHDL_NO);
    }
#endif
    
    {
      // Interface "shifter"
       in_SHIFTER_DATA      = new SC_IN (Tdata_t)      * [_param._nb_port];
      if (_param._shift_value == 0)
       in_SHIFTER_SHIFT     = new SC_IN (Tshift_t)     * [_param._nb_port];
      if (_param._direction   == external_direction)
       in_SHIFTER_DIRECTION = new SC_IN (Tdirection_t) * [_param._nb_port];
      if (_param._rotate      == external_rotate)
       in_SHIFTER_TYPE      = new SC_IN (Ttype_t)      * [_param._nb_port];
      if (_param._carry       == external_carry)
       in_SHIFTER_CARRY     = new SC_IN (Tcarry_t)     * [_param._nb_port];
      if (_param._carry       == external_completion)
      if (_param._type_completion_bool == true)
       in_SHIFTER_CARRY_IN  = new SC_IN (Tcontrol_t)   * [_param._nb_port];
      else
       in_SHIFTER_COMPLETION= new SC_IN (Tdata_t)      * [_param._nb_port];
      out_SHIFTER_DATA      = new SC_OUT(Tdata_t)      * [_param._nb_port];
      
      for (uint32_t i=0; i<_param._nb_port; i++)
	{
	  Interface_fifo * interface = _interfaces->set_interface("shifter_"+toString(i)
#ifdef POSITION
								  , IN  
								  , SOUTH
								  , "Generalist interface"
#endif
								  );
	 
	   in_SHIFTER_DATA       [i] = interface->set_signal_in  <Tdata_t     > ("data"      ,_param._size_data);
	  if (_param._shift_value == 0)
	   in_SHIFTER_SHIFT      [i] = interface->set_signal_in  <Tshift_t    > ("shift"     ,static_cast<uint32_t>(ceil(log2(_param._size_data))));
	  if (_param._direction == external_direction)
	   in_SHIFTER_DIRECTION  [i] = interface->set_signal_in  <Tdirection_t> ("direction" ,1);
	  if (_param._rotate  == external_rotate)
	   in_SHIFTER_TYPE       [i] = interface->set_signal_in  <Ttype_t     > ("type"      ,1);
	  if (_param._carry == external_carry)
	   in_SHIFTER_CARRY      [i] = interface->set_signal_in  <Tcarry_t    > ("carry"     ,1);
	  if (_param._carry       == external_completion)
	  if (_param._type_completion_bool == true)
	   in_SHIFTER_CARRY_IN   [i] = interface->set_signal_in  <Tcontrol_t  > ("carry_in"  ,1);
	  else
	   in_SHIFTER_COMPLETION [i] = interface->set_signal_in  <Tdata_t     > ("completion",_param._size_data_completion);
	  out_SHIFTER_DATA       [i] = interface->set_signal_out <Tdata_t     > ("data"      ,_param._size_data);
	}										                                         
    }

#ifdef POSITION
    _component->generate_file();
#endif

  };
  
}; // end namespace shifter
}; // end namespace generic
}; // end namespace behavioural
}; // end namespace morpheo              
#endif
