#ifdef SYSTEMC
/*
 * $Id: Victim_Pseudo_LRU_allocation.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include "Behavioural/Generic/Victim/Victim_Pseudo_LRU/include/Victim_Pseudo_LRU.h"
#include "Behavioural/include/Allocation.h"

namespace morpheo {
namespace behavioural {
namespace generic {
namespace victim {
namespace victim_pseudo_lru {

  void Victim_Pseudo_LRU::allocation (void)
  {
    _component   = new Component ();

    Entity * entity = _component->set_entity (_name                  
					      ,"Select_Priority_Fixed"
#ifdef POSITION
					      ,COMBINATORY           
#endif
					      );
    
    _interfaces = entity->set_interfaces();

    // ~~~~~[Interface : "" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      Interface_fifo * interface = _interfaces->set_interface(""
#ifdef POSITION
							      , IN  ,WEST, "Generalist interface"
#endif
							      );
      
      in_CLOCK        = interface->set_signal_clk              ("clock" ,1);
      in_NRESET       = interface->set_signal_in  <Tcontrol_t> ("nreset",1);
    }

    // ~~~~~[Interface : "access" ]~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    {
      ALLOC1_INTERFACE("access",IN,WEST, "Access", _param->_nb_access);

      ALLOC1_VALACK_IN ( in_ACCESS_VAL    ,VAL);
      ALLOC1_VALACK_OUT(out_ACCESS_ACK    ,ACK);
      ALLOC1_SIGNAL_IN ( in_ACCESS_HIT    ,"hit"    ,Tcontrol_t,1);
      ALLOC1_SIGNAL_IN ( in_ACCESS_ADDRESS,"address",Taddress_t,log2(_param->_size_address));
      ALLOC1_SIGNAL_IN ( in_ACCESS_ENTITY ,"entity" ,Tentity_t ,log2(_param->_nb_entity   ));
      ALLOC1_SIGNAL_OUT(out_ACCESS_VICTIM ,"victim" ,Tentity_t ,log2(_param->_nb_entity   ));
    }

    // -----[Register ]---------------------------------------------------
    reg_TABLE = new entry_t *  [_param->_size_table];

    for (uint32_t i=0; i<_param->_size_table; i++)
      reg_TABLE [i] = new entry_t (_param->_nb_entity);
    
    // -----[Internal ]---------------------------------------------------
    internal_ACCESS_ACK    = new Tcontrol_t [_param->_nb_access];
    internal_ACCESS_VICTIM = new Tentity_t  [_param->_nb_access];

#ifdef POSITION
    _component->generate_file();
#endif
  };

}; // end namespace victim_pseudo_lru
}; // end namespace victim
}; // end namespace generic

}; // end namespace behavioural
}; // end namespace morpheo              
#endif
