#ifndef morpheo_behavioural_Interfaces_h
#define morpheo_behavioural_Interfaces_h

/*
 * $Id: Interfaces.h 81 2008-04-15 18:40:01Z rosiere $
 *
 * [Description ]
 * 
 */

#include <stdint.h>
#include <iostream>
#include <list>
#include "Behavioural/include/Interface_fifo.h"
#include "Common/include/ToString.h"
#include "Common/include/Debug.h"
#ifdef VHDL
#include "Behavioural/include/Vhdl.h"
#endif
#include "Behavioural/include/Usage.h"


namespace morpheo              {
namespace behavioural          {

  class Interfaces
  {
    // -----[fields ]----------------------------------------------------
  private   : const std::string               _name;
  private   : const Tusage_t             _usage;
  private   : std::list<Interface_fifo*>    * _list_interface;

    // -----[methods ]---------------------------------------------------
  public    :                       Interfaces            (std::string name, 
							   Tusage_t usage=USE_ALL);
  public    :                       Interfaces            (const Interfaces & interfaces);
  public    :                       ~Interfaces           ();

  public    : Interface_fifo *      set_interface         (std::string         name        
#ifdef POSITION
							   ,direction_t    direction   
							   ,localisation_t localisation
#endif
							   );
#ifdef POSITION
  public    : Interface_fifo *      set_interface         (std::string         name        ,
							   direction_t    direction   ,
							   localisation_t localisation,
							   std::string         comment     );
#endif
  private   : std::string                get_interface         (void);
  public    :std::list<Interface_fifo*>* get_interface_list    (void);

#ifdef VHDL
  public    : void                  set_port              (Vhdl           * & vhdl          );
#  ifdef VHDL_TESTBENCH
  private   : void                  get_signal            (std::list<std::string>   * & list_signal   );
  private   : void                  set_signal            (Vhdl           * & vhdl          );
#  endif
#endif
#ifdef VHDL_TESTBENCH
  private   : uint32_t              get_cycle             (void);
  private   : Signal *              get_clock             (void);
  private   : Signal *              get_reset             (void);

  private   : void                  testbench_generate_file (void);
  public    : void                  testbench             (void);
  private   : std::string                testbench_body        (Vhdl           * & vhdl          ,
							   std::string             counter_name  ,
							   std::string             reset_name    );
#endif

  public    : Interface_fifo  *     find_interface        (std::string name);
  public    : Signal          *     find_signal           (std::string name);
  public    : bool                  find_signal           (Signal * signal);

#ifdef POSITION
  public    : XML                   toXML                 (void);
  public    : XML                   toXML_mapping         (void);
#endif

  public    : bool                  test_map              (uint32_t depth, bool top_level);

  public    : friend std::ostream&       operator<<            (std::ostream& output_stream,
								morpheo::behavioural::Interfaces & x);

  };

}; // end namespace behavioural          
}; // end namespace morpheo              

#endif
