/*
 * $Id: Signal_test_map.cpp 81 2008-04-15 18:40:01Z rosiere $
 *
 * [ Description ]
 * 
 */

#include "Behavioural/include/Signal.h"


namespace morpheo              {
namespace behavioural          {

#undef  FUNCTION
#define FUNCTION "Signal::test_map"
  bool Signal::test_map (uint32_t depth, bool top_level)
  {
    log_printf(FUNC,Behavioural,FUNCTION,"Begin");

    std::string str = "";
    std::string tab = std::string(depth,'\t');
//     log_printf(NONE,Behavioural,FUNCTION, "%s* Signal \"%s\"",tab.c_str(),_name.c_str());
//     log_printf(NONE,Behavioural,FUNCTION, "%s%d - %d - %d",tab.c_str(),
// 	       _is_map_as_toplevel_dest,
// 	       _is_map_as_component_src,
// 	       _is_map_as_component_dest);
    bool _return = true;

    if (top_level == true)
      {
	switch (_direction)
	  {
	  case morpheo::behavioural::IN       : 
	    {
	      if (_is_map_as_toplevel_dest == false)
		{
		  _return = false;

		  str = "Signal \""+_name+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		}
	      break;
	    }
	  case morpheo::behavioural::OUT      : 
	    {
	      if (_is_map_as_toplevel_dest == false)
		{
		  _return = false;
		  str = "Signal \""+_name+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		}
	      break;
	    }
	    //case morpheo::behavioural::INTERNAL :
	    //case morpheo::behavioural::INOUT    :
	  default    : break;
	  }
      }
    else
      {
	// internal signal :
	// Component --- I/O       (as_src)
	// Component --- Component (as_src and as_dest)

	switch (_direction)
	  {
	  case morpheo::behavioural::IN       : 
	    {
	      if (_is_map_as_component_src == false)
		{
		  _return = false;
		  
		  str = "Signal \""+_name+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		}
	      break;
	    }
	  case morpheo::behavioural::OUT      : 
	    {
	      if (_is_map_as_component_src == false)
		{
		  _return = false;
		  
		  str = "Signal \""+_name+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		}
	      break;
	    }
	  case morpheo::behavioural::INTERNAL : 
	    {
	      if (_is_map_as_component_src  == false)
		{
		  _return = false;
		  
		  str = "Internal signal \""+_name+"\" is not mapped with an outpout port top-level's interface or a input port component's interface.";
		}

	      if (_is_map_as_component_dest == false)
		{
		  if (_return == false)
		    str+="\n";

		  _return = false;
		  
		  str += "Internal signal \""+_name+"\" is not mapped with an input port top-level's interface or a output port component's interface.";
		}

	      break;
	    }
	    //case morpheo::behavioural::INOUT    :
	  default    : break;
	  }
      }
    
    log_printf(FUNC,Behavioural,FUNCTION,"End");



    if (_return == false)
      {
	log_printf(NONE,Behavioural,FUNCTION, "%s* %s",tab.c_str(),str.c_str());
	
#ifndef DEBUG
	std::cerr << str << std::endl;
#endif
      }
    else
      {
// 	log_printf(NONE,Behavioural,FUNCTION, "%s* Signal \"%s\" is OK.",tab.c_str(),_name.c_str());
      }
    
    return _return;
  };

}; // end namespace behavioural          
}; // end namespace morpheo              
